/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.sectiontransformer.materials;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.transformer.BookTransformer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.book.content.ContentMaterial;
import slimeknights.tconstruct.library.client.book.sectiontransformer.materials.AbstractMaterialSectionTransformer;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

public class TierRangeMaterialSectionTransformer
extends BookTransformer {
    private static final Set<MaterialStatsId> VISIBLE_STATS = ImmutableSet.of((Object)((Object)HeadMaterialStats.ID), (Object)((Object)HandleMaterialStats.ID), (Object)((Object)ExtraMaterialStats.ID));
    private static final ResourceLocation KEY = TConstruct.getResource("material_tier");
    public static final TierRangeMaterialSectionTransformer INSTANCE = new TierRangeMaterialSectionTransformer();

    public void transform(BookData book) {
        for (SectionData section : book.sections) {
            JsonElement json = (JsonElement)section.extraData.get(KEY);
            if (json == null) continue;
            try {
                boolean detailed;
                int max;
                int min;
                if (json.isJsonPrimitive()) {
                    max = min = json.getAsInt();
                    detailed = false;
                } else if (json.isJsonObject()) {
                    JsonObject jsonObject = json.getAsJsonObject();
                    if (jsonObject.has("tier")) {
                        max = min = GsonHelper.m_13927_((JsonObject)jsonObject, (String)"tier");
                    } else {
                        min = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"min", (int)0);
                        max = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"max", (int)Integer.MAX_VALUE);
                    }
                    detailed = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"detailed", (boolean)false);
                } else {
                    throw new JsonSyntaxException("Invalid tconstruct:material_tier, expected number or JSON object");
                }
                AbstractMaterialSectionTransformer.createPages(book, section, new ValidMaterial(VISIBLE_STATS, min, max), id -> new ContentMaterial((MaterialVariantId)id, detailed));
            }
            catch (JsonSyntaxException e) {
                TConstruct.LOG.error("Failed to parse material tier section data", (Throwable)e);
            }
        }
    }

    public record ValidMaterial(Set<MaterialStatsId> visibleStats, int min, int max) implements Predicate<IMaterial>
    {
        @Override
        public boolean test(IMaterial material) {
            int tier = material.getTier();
            if (tier < this.min || tier > this.max) {
                return false;
            }
            for (IMaterialStats stats : MaterialRegistry.getInstance().getAllStats(material.getIdentifier())) {
                if (!this.visibleStats.contains((Object)stats.getIdentifier())) continue;
                return true;
            }
            return false;
        }
    }
}

