/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.gadgets.entity.FrameType;
import slimeknights.tconstruct.library.utils.Util;

public class FancyItemFrameEntity
extends ItemFrame
implements IEntityAdditionalSpawnData {
    private static final int DIAMOND_TIMER = 300;
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(FancyItemFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final String TAG_VARIANT = "Variant";
    private static final String TAG_ROTATION_TIMER = "RotationTimer";
    private int rotationTimer = 0;

    public FancyItemFrameEntity(EntityType<? extends FancyItemFrameEntity> type, Level level) {
        super(type, level);
    }

    public FancyItemFrameEntity(Level levelIn, BlockPos blockPos, Direction face, FrameType variant) {
        super((EntityType)TinkerGadgets.itemFrameEntity.get(), levelIn);
        this.f_31698_ = blockPos;
        this.m_6022_(face);
        this.f_19804_.m_135381_(VARIANT, (Object)variant.getId());
    }

    private static boolean doesRotate(int type) {
        return type == FrameType.GOLD.getId() || type == FrameType.REVERSED_GOLD.getId() || type == FrameType.DIAMOND.getId();
    }

    public void updateRotationTimer(boolean overturn) {
        this.rotationTimer = overturn ? -300 : 0;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        InteractionResult result;
        BlockPos behind;
        BlockState state;
        if (!player.m_6144_() && this.getFrameId() == FrameType.CLEAR.getId() && !this.m_31822_().m_41619_() && !(state = this.f_19853_.m_8055_(behind = this.m_142538_().m_142300_(this.f_31699_.m_122424_()))).m_60795_() && (result = state.m_60664_(this.f_19853_, player, hand, Util.createTraceResult(behind, this.f_31699_, false))).m_19077_()) {
            return result;
        }
        return super.m_6096_(player, hand);
    }

    public void m_8119_() {
        super.m_8119_();
        int frameId = this.getFrameId();
        if (frameId == FrameType.DIAMOND.getId()) {
            ++this.rotationTimer;
            if (this.rotationTimer >= 300) {
                int curRotation;
                this.rotationTimer = 0;
                if (!this.f_19853_.f_46443_ && (curRotation = this.m_31823_()) > 0) {
                    this.m_31770_(curRotation - 1);
                }
            }
            return;
        }
        if (!this.f_19853_.f_46443_ && FancyItemFrameEntity.doesRotate(frameId)) {
            ++this.rotationTimer;
            if (this.rotationTimer >= 20) {
                this.rotationTimer = 0;
                int curRotation = this.m_31823_();
                if (frameId == FrameType.REVERSED_GOLD.getId()) {
                    if (--curRotation == -1) {
                        curRotation = 7;
                    }
                    this.m_31770_(curRotation);
                } else {
                    this.m_31770_(curRotation + 1);
                }
            }
        }
    }

    public void m_31789_(ItemStack stack, boolean updateComparator) {
        super.m_31789_(stack, updateComparator);
        if (updateComparator && !this.f_19853_.f_46443_ && FancyItemFrameEntity.doesRotate(this.getFrameId())) {
            this.m_31772_(0, false);
        }
    }

    private void setRotationRaw(int rotationIn, boolean updateComparator) {
        this.m_20088_().m_135381_(f_31758_, (Object)rotationIn);
        if (updateComparator) {
            this.f_19853_.m_46717_(this.f_31698_, Blocks.f_50016_);
        }
    }

    protected void m_31772_(int rotationIn, boolean updateComparator) {
        this.rotationTimer = 0;
        if (this.getFrameId() == FrameType.DIAMOND.getId()) {
            if (!this.f_19853_.f_46443_ && updateComparator) {
                this.m_5496_(Sounds.ITEM_FRAME_CLICK.getSound(), 1.0f, 1.0f);
            }
            this.setRotationRaw(Math.min(rotationIn, 16), updateComparator);
        } else {
            this.setRotationRaw(rotationIn % 8, updateComparator);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public FrameType getFrameType() {
        return FrameType.byId(this.getFrameId());
    }

    public Item getFrameItem() {
        return (Item)TinkerGadgets.itemFrame.get((Enum)this.getFrameType());
    }

    protected int getFrameId() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    @Nullable
    public ItemEntity m_5552_(ItemStack stack, float offset) {
        if (stack.m_41720_() == Items.f_42617_) {
            stack = new ItemStack((ItemLike)this.getFrameItem());
        }
        return super.m_5552_(stack, offset);
    }

    public ItemStack getPickedResult(HitResult target) {
        ItemStack held = this.m_31822_();
        if (held.m_41619_()) {
            return new ItemStack((ItemLike)this.getFrameItem());
        }
        return held.m_41777_();
    }

    public boolean m_5825_() {
        return super.m_5825_() || this.getFrameId() == FrameType.NETHERITE.getId();
    }

    public boolean m_6128_() {
        return super.m_6128_() || this.getFrameId() == FrameType.NETHERITE.getId();
    }

    public int m_31824_() {
        if (this.m_31822_().m_41619_()) {
            return 0;
        }
        int rotation = this.m_31823_();
        if (this.getFrameId() == FrameType.DIAMOND.getId()) {
            return Math.min(15, rotation + 1);
        }
        return rotation % 8 + 1;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        int frameId = this.getFrameId();
        compound.m_128405_(TAG_VARIANT, frameId);
        if (FancyItemFrameEntity.doesRotate(frameId)) {
            compound.m_128405_(TAG_ROTATION_TIMER, this.rotationTimer);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        int frameId = compound.m_128451_(TAG_VARIANT);
        this.f_19804_.m_135381_(VARIANT, (Object)frameId);
        if (FancyItemFrameEntity.doesRotate(frameId)) {
            this.rotationTimer = compound.m_128451_(TAG_ROTATION_TIMER);
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.getFrameId());
        buffer.m_130064_(this.f_31698_);
        buffer.m_130130_(this.f_31699_.m_122411_());
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.f_19804_.m_135381_(VARIANT, (Object)buffer.m_130242_());
        this.f_31698_ = buffer.m_130135_();
        this.m_6022_(Direction.m_122376_((int)buffer.m_130242_()));
    }

    protected Component m_5677_() {
        return new TranslatableComponent(this.getFrameItem().m_5524_());
    }
}

