/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.fluids.item;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import slimeknights.tconstruct.library.utils.Util;

public class PotionBucketItem
extends PotionItem {
    private final Supplier<? extends Fluid> supplier;

    public PotionBucketItem(Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(builder);
        this.supplier = supplier;
    }

    public Fluid getFluid() {
        return this.supplier.get();
    }

    public String m_5671_(ItemStack stack) {
        String bucketKey = PotionUtils.m_43577_((CompoundTag)stack.m_41783_()).m_43492_(this.m_5524_() + ".effect.");
        if (Util.canTranslate(bucketKey)) {
            return bucketKey;
        }
        return super.m_5524_();
    }

    public Component m_7626_(ItemStack stack) {
        Potion potion = PotionUtils.m_43577_((CompoundTag)stack.m_41783_());
        String bucketKey = potion.m_43492_(this.m_5524_() + ".effect.");
        if (Util.canTranslate(bucketKey)) {
            return new TranslatableComponent(bucketKey);
        }
        return new TranslatableComponent(this.m_5524_() + ".contents", new Object[]{new TranslatableComponent(potion.m_43492_("item.minecraft.potion.effect."))});
    }

    public ItemStack m_7968_() {
        return PotionUtils.m_43549_((ItemStack)super.m_7968_(), (Potion)Potions.f_43599_);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity living) {
        Player p;
        Player player;
        Player player2 = player = living instanceof Player ? (p = (Player)living) : null;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.f_10592_.m_23682_(serverPlayer, stack);
        }
        if (!level.f_46443_) {
            for (MobEffectInstance effect : PotionUtils.m_43547_((ItemStack)stack)) {
                if (effect.m_19544_().m_8093_()) {
                    effect.m_19544_().m_19461_((Entity)player, (Entity)player, living, effect.m_19564_(), 2.5);
                    continue;
                }
                MobEffectInstance newEffect = new MobEffectInstance(effect);
                newEffect.f_19503_ = newEffect.f_19503_ * 5 / 2;
                living.m_7292_(newEffect);
            }
        }
        if (player != null) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        }
        if (player == null || !player.m_150110_().f_35937_) {
            if (stack.m_41619_()) {
                return new ItemStack((ItemLike)Items.f_42446_);
            }
            if (player != null) {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42446_));
            }
        }
        level.m_142346_((Entity)living, GameEvent.f_157805_, living.m_146901_());
        return stack;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        PotionUtils.m_43555_((ItemStack)pStack, pTooltip, (float)2.5f);
    }

    public int m_8105_(ItemStack pStack) {
        return 96;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new PotionBucketWrapper(stack);
    }

    public static class PotionBucketWrapper
    extends FluidBucketWrapper {
        public PotionBucketWrapper(ItemStack container) {
            super(container);
        }

        @Nonnull
        public FluidStack getFluid() {
            return new FluidStack(((PotionBucketItem)this.container.m_41720_()).getFluid(), 1000, this.container.m_41783_());
        }
    }
}

