/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics.renderer.multitexture;

import com.mojang.blaze3d.shaders.ProgramManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Objects;
import java.util.function.IntConsumer;
import net.minecraft.client.renderer.RenderType;

public class MultiTextureRenderTypeRenderer {
    private boolean used;
    private BufferBuilder bufferBuilder = new BufferBuilder(256);
    private IntArrayList texturesForDrawCalls = new IntArrayList();
    private IntConsumer textureBinderShader;
    private IntConsumer textureBinder;
    private Runnable textureFinalizer;
    private int prevTextureId;
    private VertexFormat prevFormat;
    private RenderType renderType;

    MultiTextureRenderTypeRenderer() {
    }

    void init(IntConsumer textureBinderShader, IntConsumer textureBinder, Runnable textureFinalizer, RenderType renderType) {
        if (this.used) {
            throw new IllegalStateException("Multi-texture renderer already in use!");
        }
        this.used = true;
        this.textureBinderShader = textureBinderShader;
        this.textureBinder = textureBinder;
        this.textureFinalizer = textureFinalizer;
        this.prevTextureId = -1;
        this.renderType = renderType;
    }

    void draw() {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (!this.texturesForDrawCalls.isEmpty()) {
            BufferBuilder bufferBuilder = this.bufferBuilder;
            IntConsumer textureBinder = this.textureBinder;
            IntConsumer textureBinderShader = this.textureBinderShader;
            Runnable textureFinalizer = this.textureFinalizer;
            boolean hasTextureFinalizer = textureFinalizer != null;
            this.renderType.m_110185_();
            bufferBuilder.m_85721_();
            boolean first = true;
            int shaderProgram = RenderSystem.m_157196_().m_142658_();
            for (Integer texture : this.texturesForDrawCalls) {
                if (texture == -1) {
                    texture = 0;
                }
                if (first) {
                    textureBinderShader.accept(texture);
                    BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
                    ProgramManager.m_85578_((int)shaderProgram);
                } else {
                    textureBinder.accept(texture);
                    BufferUploader.m_166847_((BufferBuilder)bufferBuilder);
                }
                if (hasTextureFinalizer) {
                    if (first) {
                        textureBinder.accept(texture);
                    }
                    textureFinalizer.run();
                }
                first = false;
            }
            textureBinderShader.accept(0);
            textureBinder.accept(0);
            this.renderType.m_110188_();
        }
        ProgramManager.m_85578_((int)0);
        this.texturesForDrawCalls.clear();
        this.used = false;
        this.renderType = null;
    }

    public BufferBuilder begin(VertexFormat.Mode mode, VertexFormat format, int textureId) {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (textureId == -1) {
            throw new IllegalStateException("Attempted to use the multi-texture renderer with texture id -1!");
        }
        if (textureId != this.prevTextureId || !Objects.equals(this.prevFormat, format)) {
            if (this.prevTextureId != -1) {
                this.bufferBuilder.m_85721_();
            }
            this.bufferBuilder.m_166779_(mode, format);
            this.prevTextureId = textureId;
            this.prevFormat = format;
            this.texturesForDrawCalls.add(textureId);
        }
        return this.bufferBuilder;
    }
}

