/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.ui.data.options.text;

import java.util.List;
import javax.annotation.Nonnull;
import xaero.common.category.ui.data.options.GuiCategoryUIEditorOptionData;
import xaero.common.misc.ListFactory;

public final class TextFieldSuggestionsResolver {
    private ListFactory listFactory;

    private TextFieldSuggestionsResolver(@Nonnull ListFactory listFactory) {
        this.listFactory = listFactory;
    }

    public List<GuiCategoryUIEditorOptionData<String>> getSuggestions(String input, List<GuiCategoryUIEditorOptionData<String>> allOptions) {
        if (input.isEmpty()) {
            return this.listFactory.get();
        }
        List result = allOptions.stream().filter(o -> o.getValue() != null && ((String)o.getValue()).toString().contains(input)).sorted((o1, o2) -> {
            boolean secondStarts;
            boolean firstStarts = ((String)o1.getValue()).toString().startsWith(input);
            return firstStarts == (secondStarts = ((String)o2.getValue()).toString().startsWith(input)) ? 0 : (firstStarts ? -1 : 1);
        }).collect(this.listFactory::get, List::add, List::addAll);
        return result;
    }

    public static final class Builder {
        private final ListFactory listFactory;

        private Builder(ListFactory listFactory) {
            this.listFactory = listFactory;
        }

        public Builder setDefault() {
            return this;
        }

        public TextFieldSuggestionsResolver build() {
            if (this.listFactory == null) {
                throw new IllegalStateException("required fields not set!");
            }
            return new TextFieldSuggestionsResolver(this.listFactory);
        }

        public static Builder getDefault(ListFactory listFactory) {
            return new Builder(listFactory).setDefault();
        }
    }
}

