/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.forge.network;

import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import java.util.UUID;
import mezz.jei.common.Constants;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketJei;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.ConnectionData;
import net.minecraftforge.network.ICustomPacket;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public final class ConnectionToServer
implements IConnectionToServer {
    @Nullable
    private static UUID jeiOnServerCacheUuid = null;
    private static boolean jeiOnServerCacheValue = false;

    @Override
    public boolean isJeiOnServer() {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientPacketListener clientPacketListener = minecraft.m_91403_();
        if (clientPacketListener == null) {
            return false;
        }
        UUID id = clientPacketListener.m_105150_();
        if (!id.equals(jeiOnServerCacheUuid)) {
            jeiOnServerCacheUuid = id;
            jeiOnServerCacheValue = Optional.of(clientPacketListener).map(ClientPacketListener::m_6198_).map(NetworkHooks::getConnectionData).map(ConnectionData::getChannels).map(ImmutableMap::keySet).map(keys -> keys.contains((Object)Constants.NETWORK_CHANNEL_ID)).orElse(false);
        }
        return jeiOnServerCacheValue;
    }

    @Override
    public void sendPacketToServer(PacketJei packet) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientPacketListener netHandler = minecraft.m_91403_();
        if (netHandler != null && this.isJeiOnServer()) {
            Pair<FriendlyByteBuf, Integer> packetData = packet.getPacketData();
            ICustomPacket payload = NetworkDirection.PLAY_TO_SERVER.buildPacket(packetData, Constants.NETWORK_CHANNEL_ID);
            netHandler.m_104955_(payload.getThis());
        }
    }
}

