/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.core.util.function;

import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class CachedSupplierTransformer<T, R>
implements Supplier<R> {
    private final Supplier<T> supplier;
    private final Function<T, R> transformer;
    @Nullable
    private T previousValue;
    @Nullable
    private R cachedResult;

    public CachedSupplierTransformer(Supplier<T> supplier, Function<T, R> transformer) {
        this.supplier = supplier;
        this.transformer = transformer;
    }

    @Override
    public R get() {
        T currentValue = this.supplier.get();
        if (this.cachedResult != null && currentValue.equals(this.previousValue)) {
            return this.cachedResult;
        }
        this.cachedResult = this.transformer.apply(currentValue);
        this.previousValue = currentValue;
        return this.cachedResult;
    }
}

