/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.color;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.common.color.ColorName;
import mezz.jei.common.color.ColorThief;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ColorGetter
implements IColorHelper {
    public static final ColorGetter INSTANCE = new ColorGetter();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<ColorName> defaultColors = List.of(new ColorName("White", 0xEEEEEE), new ColorName("LightBlue", 7639756), new ColorName("Cyan", 61166), new ColorName("Blue", 0x2222DD), new ColorName("LapisBlue", 2441611), new ColorName("Teal", 32896), new ColorName("Yellow", 13290328), new ColorName("GoldenYellow", 15652608), new ColorName("Orange", 14251572), new ColorName("Pink", 13732253), new ColorName("HotPink", 0xFC0FC0), new ColorName("Magenta", 0xB24BBB), new ColorName("Purple", 8470201), new ColorName("EvilPurple", 3020361), new ColorName("Lavender", 11894492), new ColorName("Indigo", 4718722), new ColorName("Sand", 14406560), new ColorName("Tan", 12295011), new ColorName("LightBrown", 10506797), new ColorName("Brown", 6507315), new ColorName("DarkBrown", 3812627), new ColorName("LimeGreen", 4436537), new ColorName("SlimeGreen", 8637299), new ColorName("Green", 32768), new ColorName("DarkGreen", 0x224D22), new ColorName("GrassGreen", 5537865), new ColorName("Red", 9843760), new ColorName("BrickRed", 11558987), new ColorName("NetherBrick", 2757910), new ColorName("Redstone", 13516342), new ColorName("Black", 0x181515), new ColorName("CharcoalGray", 0x464646), new ColorName("IronGray", 0x646464), new ColorName("Gray", 0x808080), new ColorName("Silver", 0xC0C0C0));

    private ColorGetter() {
    }

    public static List<ColorName> getColorDefaults() {
        return defaultColors;
    }

    public static List<Integer> getColors(ItemStack itemStack, int colorCount) {
        try {
            return ColorGetter.unsafeGetColors(itemStack, colorCount);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.debug("Failed to get color name for {}", (Object)itemStackInfo, (Object)e);
            return Collections.emptyList();
        }
    }

    private static List<Integer> unsafeGetColors(ItemStack itemStack, int colorCount) {
        Item item = itemStack.m_41720_();
        if (itemStack.m_41619_()) {
            return Collections.emptyList();
        }
        if (item instanceof BlockItem) {
            BlockItem itemBlock = (BlockItem)item;
            Block block = itemBlock.m_40614_();
            if (block == null) {
                return Collections.emptyList();
            }
            return ColorGetter.getBlockColors(block, colorCount);
        }
        return ColorGetter.getItemColors(itemStack, colorCount);
    }

    private static List<Integer> getItemColors(ItemStack itemStack, int colorCount) {
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        ItemColors itemColors = renderHelper.getItemColors();
        int renderColor = itemColors.m_92676_(itemStack, 0);
        TextureAtlasSprite textureAtlasSprite = ColorGetter.getTextureAtlasSprite(itemStack);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return INSTANCE.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    private static List<Integer> getBlockColors(Block block, int colorCount) {
        BlockState blockState = block.m_49966_();
        BlockColors blockColors = Minecraft.m_91087_().m_91298_();
        int renderColor = blockColors.m_92577_(blockState, null, null, 0);
        TextureAtlasSprite textureAtlasSprite = ColorGetter.getTextureAtlasSprite(blockState);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return INSTANCE.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    @Override
    public List<Integer> getColors(TextureAtlasSprite textureAtlasSprite, int renderColor, int colorCount) {
        int[][] palette;
        if (colorCount <= 0) {
            return Collections.emptyList();
        }
        NativeImage bufferedImage = ColorGetter.getNativeImage(textureAtlasSprite);
        if (bufferedImage == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> colors = new ArrayList<Integer>(colorCount);
        for (int[] colorInt : palette = ColorThief.getPalette(bufferedImage, colorCount, 2, false)) {
            int red = (int)((float)(colorInt[0] - 1) * (float)(renderColor >> 16 & 0xFF) / 255.0f);
            int green = (int)((float)(colorInt[1] - 1) * (float)(renderColor >> 8 & 0xFF) / 255.0f);
            int blue = (int)((float)(colorInt[2] - 1) * (float)(renderColor & 0xFF) / 255.0f);
            red = Mth.m_14045_((int)red, (int)0, (int)255);
            green = Mth.m_14045_((int)green, (int)0, (int)255);
            blue = Mth.m_14045_((int)blue, (int)0, (int)255);
            int color = 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
            colors.add(color);
        }
        return colors;
    }

    @Nullable
    private static NativeImage getNativeImage(TextureAtlasSprite textureAtlasSprite) {
        int iconWidth = textureAtlasSprite.m_118405_();
        int iconHeight = textureAtlasSprite.m_118408_();
        if (iconWidth <= 0 || iconHeight <= 0) {
            return null;
        }
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        return renderHelper.getMainImage(textureAtlasSprite);
    }

    @Nullable
    private static TextureAtlasSprite getTextureAtlasSprite(BlockState blockState) {
        Minecraft minecraft = Minecraft.m_91087_();
        BlockRenderDispatcher blockRendererDispatcher = minecraft.m_91289_();
        BlockModelShaper blockModelShapes = blockRendererDispatcher.m_110907_();
        BakedModel blockModel = blockModelShapes.m_110893_(blockState);
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        TextureAtlasSprite textureAtlasSprite = renderHelper.getParticleIcon(blockModel);
        if (textureAtlasSprite instanceof MissingTextureAtlasSprite) {
            return null;
        }
        return textureAtlasSprite;
    }

    @Nullable
    private static TextureAtlasSprite getTextureAtlasSprite(ItemStack itemStack) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemModelShaper itemModelMesher = itemRenderer.m_115103_();
        BakedModel itemModel = itemModelMesher.m_109406_(itemStack);
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        TextureAtlasSprite particleTexture = renderHelper.getParticleIcon(itemModel);
        if (particleTexture instanceof MissingTextureAtlasSprite) {
            return null;
        }
        return particleTexture;
    }
}

