/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.common.network;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import io.github.edwinmindcraft.origins.common.OriginsCommon;
import io.github.edwinmindcraft.origins.common.network.S2CConfirmOrigin;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record C2SChooseRandomOrigin(ResourceLocation layer) {
    public static C2SChooseRandomOrigin decode(FriendlyByteBuf buf) {
        return new C2SChooseRandomOrigin(buf.m_130281_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.layer());
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (sender == null) {
                return;
            }
            IOriginContainer.get((Entity)sender).ifPresent(container -> {
                OriginLayer layer = (OriginLayer)OriginsAPI.getLayersRegistry().m_7745_(this.layer());
                if (layer == null) {
                    Origins.LOGGER.warn("Player {} tried to select a random origin for missing layer {}", (Object)sender.m_6302_(), (Object)this.layer());
                    return;
                }
                if (container.hasAllOrigins() || container.hasOrigin(layer)) {
                    Origins.LOGGER.warn("Player {} tried to choose origin for layer {} while having one already.", (Object)sender.m_6302_(), (Object)this.layer());
                    return;
                }
                Optional<Origin> selected = layer.selectRandom((Player)sender);
                if (!layer.allowRandom() || selected.isEmpty()) {
                    Origins.LOGGER.warn("Player {} tried to choose a random Origin for layer {}, which is not allowed!", (Object)sender.m_6302_(), (Object)this.layer());
                    container.setOrigin(layer, Origin.EMPTY);
                    return;
                }
                Origin origin = selected.get();
                boolean hadOriginBefore = container.hadAllOrigins();
                boolean hadAllOrigins = container.hasAllOrigins();
                container.setOrigin(layer, origin);
                container.checkAutoChoosingLayers(false);
                container.synchronize();
                if (container.hasAllOrigins() && !hadAllOrigins) {
                    OriginComponent.onChosen((Player)sender, hadOriginBefore);
                }
                Origins.LOGGER.info("Player {} was randomly assigned the following Origin: \"{}\" for layer: {}", (Object)sender.m_6302_(), (Object)origin.getRegistryName(), (Object)this.layer());
                OriginsCommon.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new S2CConfirmOrigin(this.layer(), origin.getRegistryName()));
            });
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

