/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.common.network;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import io.github.edwinmindcraft.origins.common.OriginsCommon;
import io.github.edwinmindcraft.origins.common.network.S2CConfirmOrigin;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record C2SChooseOrigin(ResourceLocation layer, ResourceLocation origin) {
    public static C2SChooseOrigin decode(FriendlyByteBuf buf) {
        return new C2SChooseOrigin(buf.m_130281_(), buf.m_130281_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.layer());
        buf.m_130085_(this.origin());
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (sender == null) {
                return;
            }
            IOriginContainer.get((Entity)sender).ifPresent(container -> {
                OriginLayer layer = (OriginLayer)OriginsAPI.getLayersRegistry().m_7745_(this.layer());
                if (layer == null) {
                    Origins.LOGGER.warn("Player {} tried to select an origin for missing layer {}", (Object)sender.m_6302_(), (Object)this.layer());
                    return;
                }
                if (container.hasAllOrigins() || container.hasOrigin(layer)) {
                    Origins.LOGGER.warn("Player {} tried to choose origin for layer {} while having one already.", (Object)sender.m_6302_(), (Object)this.layer());
                    return;
                }
                Origin origin = (Origin)((Object)((Object)((Object)OriginsAPI.getOriginsRegistry().m_7745_(this.origin()))));
                if (origin == null) {
                    Origins.LOGGER.warn("Player {} chose unknown origin: {} for layer {}", (Object)sender.m_6302_(), (Object)this.origin(), (Object)this.layer());
                    return;
                }
                if (!origin.isChoosable() || !layer.contains(this.origin(), (Player)sender)) {
                    Origins.LOGGER.warn("Player {} tried to choose invalid origin: {} for layer: {}", (Object)sender.m_6302_(), (Object)this.origin(), (Object)this.layer());
                    container.setOrigin(layer, Origin.EMPTY);
                } else {
                    boolean hadOriginBefore = container.hadAllOrigins();
                    boolean hadAllOrigins = container.hasAllOrigins();
                    container.setOrigin(layer, origin);
                    container.checkAutoChoosingLayers(false);
                    if (container.hasAllOrigins() && !hadAllOrigins) {
                        OriginComponent.onChosen((Player)sender, hadOriginBefore);
                    }
                }
                container.synchronize();
                OriginsCommon.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new S2CConfirmOrigin(this.layer(), this.origin()));
            });
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

