/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.common.capabilities;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.component.PlayerOriginComponent;
import io.github.apace100.origins.util.ChoseOriginCriterion;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.IOriginCallbackPower;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import io.github.edwinmindcraft.origins.common.OriginsCommon;
import io.github.edwinmindcraft.origins.common.network.S2CSynchronizeOrigin;
import io.github.edwinmindcraft.origins.common.registry.OriginRegisters;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OriginContainer
implements IOriginContainer,
ICapabilitySerializable<Tag> {
    public static final ResourceLocation ID = Origins.identifier("origins");
    private final Player player;
    private final Map<OriginLayer, Origin> layers;
    private final AtomicBoolean synchronization;
    private final AtomicBoolean hadAllOrigins;
    private boolean cleanupPowers = true;
    private final Lazy<OriginComponent> component = Lazy.of(() -> new PlayerOriginComponent(this));
    private final LazyOptional<IOriginContainer> thisOptional = LazyOptional.of(() -> this);
    private final AtomicInteger syncCooldown = new AtomicInteger(0);

    public OriginContainer(Player player) {
        this.player = player;
        this.layers = new ConcurrentHashMap<OriginLayer, Origin>();
        this.synchronization = new AtomicBoolean();
        this.hadAllOrigins = new AtomicBoolean();
    }

    @Override
    public void setOrigin(@NotNull OriginLayer layer, @NotNull Origin origin) {
        Origin previous = this.layers.put(layer, origin);
        if (!Objects.equals((Object)origin, (Object)previous)) {
            IPowerContainer.get((Entity)this.player).ifPresent(container -> {
                this.grantPowers((IPowerContainer)container, origin);
                if (previous != null) {
                    container.removeAllPowersFromSource(OriginsAPI.getPowerSource(previous));
                }
                if (this.hasAllOrigins()) {
                    this.hadAllOrigins.set(true);
                }
            });
            this.synchronize();
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                ChoseOriginCriterion.INSTANCE.trigger(sp, origin);
            }
        }
    }

    private void grantPowers(IPowerContainer container, Origin origin) {
        ResourceLocation powerSource = OriginsAPI.getPowerSource(origin);
        Registry<ConfiguredPower<?, ?>> powers = ApoliAPI.getPowers();
        for (ResourceLocation power : origin.getPowers()) {
            ConfiguredPower configuredPower = (ConfiguredPower)powers.m_7745_(power);
            if (configuredPower == null || container.hasPower(power, powerSource)) continue;
            container.addPower(power, powerSource);
        }
    }

    @Override
    @NotNull
    public Origin getOrigin(@NotNull OriginLayer layer) {
        return this.layers.getOrDefault(layer, Origin.EMPTY);
    }

    @Override
    public boolean hasOrigin(@NotNull OriginLayer layer) {
        return !Objects.equals((Object)this.getOrigin(layer), OriginRegisters.EMPTY.get());
    }

    @Override
    public boolean hadAllOrigins() {
        return this.hadAllOrigins.get();
    }

    @Override
    @NotNull
    public Map<OriginLayer, Origin> getOrigins() {
        return ImmutableMap.copyOf(this.layers);
    }

    @Override
    public void synchronize() {
        this.synchronization.compareAndSet(false, true);
    }

    @Override
    public boolean shouldSync() {
        return this.synchronization.get();
    }

    @Override
    @NotNull
    public Player getOwner() {
        return this.player;
    }

    @Override
    public void tick() {
        if (this.cleanupPowers) {
            this.cleanupPowers = false;
            IPowerContainer.get((Entity)this.player).ifPresent(container -> {
                for (Origin origin : this.layers.values()) {
                    ResourceLocation powerSource = OriginsAPI.getPowerSource(origin);
                    ImmutableSet currentPowers = ImmutableSet.copyOf(container.getPowersFromSource(powerSource));
                    Registry<ConfiguredPower<?, ?>> registry = ApoliAPI.getPowers(this.player.m_20194_());
                    Set newPowers = (Set)origin.getPowers().stream().map(arg_0 -> registry.m_7745_(arg_0)).filter(Objects::nonNull).flatMap(x -> {
                        HashSet<ResourceLocation> names = new HashSet<ResourceLocation>();
                        names.add(x.getRegistryName());
                        x.getChildren().stream().filter(Holder::m_203633_).map(Holder::m_203334_).map(ConfiguredPower::getRegistryName).forEach(names::add);
                        return names.stream();
                    }).collect(ImmutableSet.toImmutableSet());
                    Set<ResourceLocation> toRemove = currentPowers.stream().filter(x -> !newPowers.contains(x)).collect(Collectors.toSet());
                    Set<ResourceLocation> toAdd = newPowers.stream().filter(arg_0 -> OriginContainer.lambda$tick$3((Set)currentPowers, arg_0)).collect(Collectors.toSet());
                    if (!toRemove.isEmpty()) {
                        toRemove.forEach(power -> container.removePower((ResourceLocation)power, powerSource));
                        Origins.LOGGER.debug("CLEANUP: Revoked {} removed powers for origin {} on player {}", (Object)toRemove.size(), (Object)origin.getRegistryName(), (Object)this.player.m_6302_());
                    }
                    if (toAdd.isEmpty()) continue;
                    toAdd.forEach(power -> container.addPower((ResourceLocation)power, powerSource));
                    Origins.LOGGER.debug("CLEANUP: Granted {} missing powers for origin {} on player {}", (Object)toAdd.size(), (Object)origin.getRegistryName(), (Object)this.player.m_6302_());
                }
            });
        }
        if (this.shouldSync() && !this.player.f_19853_.m_5776_() && this.syncCooldown.decrementAndGet() <= 0) {
            OriginsCommon.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.player), (Object)this.getSynchronizationPacket());
            this.syncCooldown.set(20);
            ApoliAPI.synchronizePowerContainer((Entity)this.player);
        }
    }

    @Override
    @NotNull
    public S2CSynchronizeOrigin getSynchronizationPacket() {
        return new S2CSynchronizeOrigin(this.player.m_142049_(), this.getLayerMap(), this.hadAllOrigins());
    }

    @NotNull
    private Map<ResourceLocation, ResourceLocation> getLayerMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Registry<OriginLayer> layers = OriginsAPI.getLayersRegistry();
        this.layers.forEach((layer, origin) -> {
            ResourceLocation key = layers.m_7981_(layer);
            ResourceLocation value = origin.getRegistryName();
            if (key != null && value != null) {
                builder.put((Object)key, (Object)value);
            }
        });
        return builder.build();
    }

    @Override
    public boolean checkAutoChoosingLayers(boolean includeDefaults) {
        boolean choseOneAutomatically = false;
        Registry<Origin> registry = OriginsAPI.getOriginsRegistry();
        for (OriginLayer layer : OriginsAPI.getActiveLayers()) {
            boolean shouldContinue = false;
            if (!this.hasOrigin(layer)) {
                Origin def;
                if (includeDefaults && layer.hasDefaultOrigin() && (def = (Origin)((Object)registry.m_7745_(layer.defaultOrigin()))) != null) {
                    this.setOrigin(layer, def);
                    choseOneAutomatically = true;
                    shouldContinue = true;
                } else {
                    Optional<Origin> automaticOrigin = layer.getAutomaticOrigin(this.player);
                    if (automaticOrigin.isPresent()) {
                        this.setOrigin(layer, automaticOrigin.get());
                        choseOneAutomatically = true;
                        shouldContinue = true;
                    } else if (layer.getOriginOptionCount(this.player) == 0) {
                        shouldContinue = true;
                    }
                }
            } else {
                shouldContinue = true;
            }
            if (shouldContinue) continue;
            break;
        }
        return choseOneAutomatically;
    }

    @Override
    public void onChosen(@NotNull Origin origin, boolean isOrb) {
        IPowerContainer.get((Entity)this.player).ifPresent(container -> container.getPowersFromSource(OriginsAPI.getPowerSource(origin)).stream().map(container::getPower).filter(Objects::nonNull).forEach(power -> IOriginCallbackPower.onChosen(power, (Entity)this.player, isOrb)));
    }

    @Override
    public void onChosen(boolean isOrb) {
        IPowerContainer.get((Entity)this.player).ifPresent(container -> container.getPowers().forEach(x -> IOriginCallbackPower.onChosen(x, (Entity)this.player, isOrb)));
    }

    @Override
    public void onReload() {
        this.cleanupPowers = true;
    }

    @Override
    @NotNull
    public OriginComponent asLegacyComponent() {
        return (OriginComponent)this.component.get();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return OriginsAPI.ORIGIN_CONTAINER.orEmpty(cap, this.thisOptional);
    }

    public void acceptSynchronization(Map<ResourceLocation, ResourceLocation> map, boolean hadAllOrigins) {
        this.layers.clear();
        Registry<OriginLayer> layers = OriginsAPI.getLayersRegistry();
        Registry<Origin> origins = OriginsAPI.getOriginsRegistry();
        map.forEach((layer, origin) -> layers.m_6612_(layer).ifPresent(l -> origins.m_6612_(origin).ifPresent(o -> this.layers.put((OriginLayer)l, (Origin)((Object)((Object)((Object)o)))))));
        this.hadAllOrigins.set(hadAllOrigins);
    }

    public Tag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        CompoundTag layers = new CompoundTag();
        this.getOrigins().forEach((layer, origin) -> {
            ResourceLocation key = layer.getRegistryName();
            ResourceLocation value = origin.getRegistryName();
            if (key == null || value == null) {
                Origins.LOGGER.warn("Removed missing entry {} ({}): {} ({})", layer, (Object)key, (Object)origin, (Object)value);
                return;
            }
            layers.m_128359_(key.toString(), value.toString());
        });
        tag.m_128365_("Origins", (Tag)layers);
        tag.m_128379_("HadAllOrigins", this.hasAllOrigins());
        return tag;
    }

    public void deserializeNBT(Tag nbt) {
        this.layers.clear();
        CompoundTag tag = (CompoundTag)nbt;
        CompoundTag layers = tag.m_128469_("Origins");
        Registry<OriginLayer> registry = OriginsAPI.getLayersRegistry();
        Registry<Origin> origins = OriginsAPI.getOriginsRegistry();
        for (String key : layers.m_128431_()) {
            String origin = layers.m_128461_(key);
            if (origin.isBlank()) continue;
            ResourceLocation orig = ResourceLocation.m_135820_((String)origin);
            if (orig == null) {
                Origins.LOGGER.warn("Invalid origin {} found for layer {} on entity {}", (Object)origin, (Object)key, (Object)this.player.m_6302_());
                continue;
            }
            Origin origin1 = (Origin)((Object)origins.m_7745_(orig));
            if (origin1 == null) {
                Origins.LOGGER.warn("Missing origin {} found for layer {} on entity {}", (Object)origin, (Object)key, (Object)this.player.m_6302_());
                IPowerContainer.get((Entity)this.player).ifPresent(container -> container.removeAllPowersFromSource(OriginsAPI.getPowerSource(orig)));
                continue;
            }
            ResourceLocation rl = ResourceLocation.m_135820_((String)key);
            if (rl == null) {
                Origins.LOGGER.warn("Invalid layer found {} on entity {}", (Object)key, (Object)this.player.m_6302_());
                IPowerContainer.get((Entity)this.player).ifPresent(container -> container.removeAllPowersFromSource(OriginsAPI.getPowerSource(origin1)));
                continue;
            }
            OriginLayer layer = (OriginLayer)registry.m_7745_(rl);
            if (layer == null) {
                Origins.LOGGER.warn("Missing layer {} on entity {}", (Object)rl, (Object)this.player.m_6302_());
                IPowerContainer.get((Entity)this.player).ifPresent(container -> container.removeAllPowersFromSource(OriginsAPI.getPowerSource(origin1)));
                continue;
            }
            this.setOrigin(layer, origin1);
        }
        this.hadAllOrigins.set(tag.m_128471_("HadAllOrigins"));
    }

    @Override
    public void validateSynchronization() {
        this.synchronization.compareAndSet(true, false);
        this.syncCooldown.set(0);
    }

    private static /* synthetic */ boolean lambda$tick$3(Set currentPowers, ResourceLocation x) {
        return !currentPowers.contains(x);
    }
}

