/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.api.origin;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityCondition;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import io.github.edwinmindcraft.calio.api.registry.ICalioDynamicRegistryManager;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.origin.ConditionedOrigin;
import io.github.edwinmindcraft.origins.api.origin.GuiTitle;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.registry.OriginsDynamicRegistries;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OriginLayer
extends ForgeRegistryEntry.UncheckedRegistryEntry<OriginLayer>
implements Comparable<OriginLayer> {
    public static final Codec<OriginLayer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CalioCodecHelper.INT.fieldOf("order").forGetter(OriginLayer::order), (App)CalioCodecHelper.setOf(ConditionedOrigin.CODEC).fieldOf("origins").forGetter(OriginLayer::conditionedOrigins), (App)CalioCodecHelper.BOOL.fieldOf("enabled").forGetter(OriginLayer::enabled), (App)CalioCodecHelper.COMPONENT_CODEC.fieldOf("name").forGetter(OriginLayer::name), (App)CalioCodecHelper.COMPONENT_CODEC.fieldOf("missing_name").forGetter(OriginLayer::missingName), (App)CalioCodecHelper.COMPONENT_CODEC.fieldOf("missing_description").forGetter(OriginLayer::missingDescription), (App)CalioCodecHelper.BOOL.fieldOf("allow_random").forGetter(OriginLayer::allowRandom), (App)CalioCodecHelper.BOOL.fieldOf("allow_random_unchoosable").forGetter(OriginLayer::allowRandomUnchoosable), (App)CalioCodecHelper.setOf(ResourceLocation.f_135803_).fieldOf("random_exclusions").forGetter(OriginLayer::randomExclusions), (App)CalioCodecHelper.optionalField(ResourceLocation.f_135803_, "default").forGetter(x -> Optional.ofNullable(x.defaultOrigin())), (App)CalioCodecHelper.BOOL.fieldOf("auto_choose").forGetter(OriginLayer::autoChoose), (App)CalioCodecHelper.optionalField(CalioCodecHelper.BOOL, "hidden", false).forGetter(OriginLayer::hidden), (App)CalioCodecHelper.optionalField(GuiTitle.CODEC, "gui_title", GuiTitle.DEFAULT).forGetter(OriginLayer::title)).apply((Applicative)instance, OriginLayer::new));
    private final int order;
    private final Set<ConditionedOrigin> conditionedOrigins;
    private final boolean enabled;
    private final Component name;
    private final Component missingName;
    private final Component missingDescription;
    private final boolean allowRandom;
    private final boolean allowRandomUnchoosable;
    private final Set<ResourceLocation> randomExclusions;
    @Nullable
    private final ResourceLocation defaultOrigin;
    private final boolean autoChoose;
    private final boolean hidden;
    private final GuiTitle title;

    public OriginLayer(int order, ResourceLocation registryName, Set<ConditionedOrigin> conditionedOrigins, boolean enabled, Component name, Component missingName, Component missingDescription, boolean allowRandom, boolean allowRandomUnchoosable, Set<ResourceLocation> randomExclusions, @Nullable ResourceLocation defaultOrigin, boolean autoChoose, boolean hidden, GuiTitle title) {
        this(order, conditionedOrigins, enabled, name, missingName, missingDescription, allowRandom, allowRandomUnchoosable, randomExclusions, defaultOrigin, autoChoose, hidden, title);
        this.setRegistryName(registryName);
    }

    public OriginLayer(int order, Set<ConditionedOrigin> conditionedOrigins, boolean enabled, Component name, Component missingName, Component missingDescription, boolean allowRandom, boolean allowRandomUnchoosable, Set<ResourceLocation> randomExclusions, @Nullable ResourceLocation defaultOrigin, boolean autoChoose, boolean hidden, GuiTitle title) {
        this.order = order;
        this.conditionedOrigins = conditionedOrigins;
        this.enabled = enabled;
        this.name = name;
        this.missingName = missingName;
        this.missingDescription = missingDescription;
        this.allowRandom = allowRandom;
        this.allowRandomUnchoosable = allowRandomUnchoosable;
        this.randomExclusions = randomExclusions;
        this.defaultOrigin = defaultOrigin;
        this.autoChoose = autoChoose;
        this.hidden = hidden;
        this.title = title;
    }

    private OriginLayer(Integer order, Set<ConditionedOrigin> conditionedOrigins, Boolean enabled, Component name, Component missingName, Component missingDescription, Boolean allowRandom, Boolean allowRandomUnchoosable, Set<ResourceLocation> randomExclusions, Optional<ResourceLocation> defaultOrigin, Boolean autoChoose, Boolean hidden, GuiTitle title) {
        this((int)order, conditionedOrigins, (boolean)enabled, name, missingName, missingDescription, (boolean)allowRandom, (boolean)allowRandomUnchoosable, randomExclusions, (ResourceLocation)defaultOrigin.orElse(null), (boolean)autoChoose, (boolean)hidden, title);
    }

    public OriginLayer cleanup(ICalioDynamicRegistryManager registries) {
        WritableRegistry<Origin> registry = registries.get(OriginsDynamicRegistries.ORIGINS_REGISTRY);
        return new OriginLayer(this.order(), (Set<ConditionedOrigin>)((Set)this.conditionedOrigins().stream().map(x -> x.cleanup(registries)).filter(x -> !x.isEmpty()).collect(ImmutableSet.toImmutableSet())), this.enabled(), this.name(), this.missingName(), this.missingDescription(), this.allowRandom(), this.allowRandomUnchoosable(), (Set<ResourceLocation>)((Set)this.randomExclusions().stream().filter(arg_0 -> registry.m_7804_(arg_0)).collect(ImmutableSet.toImmutableSet())), this.defaultOrigin(), this.autoChoose(), this.hidden(), this.title());
    }

    public boolean hasDefaultOrigin() {
        return this.defaultOrigin() != null;
    }

    public Set<ResourceLocation> origins() {
        return this.conditionedOrigins().stream().flatMap(ConditionedOrigin::stream).collect(Collectors.toSet());
    }

    public Set<ResourceLocation> origins(Player player) {
        return this.conditionedOrigins().stream().flatMap(x -> x.stream(player)).collect(Collectors.toSet());
    }

    public boolean empty() {
        return this.conditionedOrigins().stream().flatMap(ConditionedOrigin::stream).findAny().isEmpty();
    }

    public boolean empty(Player player) {
        return this.conditionedOrigins().stream().flatMap(x -> x.stream(player)).findAny().isEmpty();
    }

    public List<ResourceLocation> randomOrigins(Player player) {
        Registry<Origin> origins = OriginsAPI.getOriginsRegistry();
        return this.conditionedOrigins().stream().flatMap(x -> x.stream(player)).filter(o -> !this.randomExclusions().contains(o)).filter(id -> origins.m_6612_(id).map(x -> this.allowRandomUnchoosable() || x.isChoosable()).orElse(false)).collect(Collectors.toList());
    }

    public boolean contains(ResourceLocation origin) {
        return this.conditionedOrigins().stream().anyMatch(x -> x.origins().contains(origin));
    }

    public boolean contains(ResourceLocation origin, Player player) {
        return this.conditionedOrigins().stream().anyMatch(x -> ConfiguredEntityCondition.check(x.condition(), (Entity)player) && x.origins().contains(origin));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OriginLayer)) {
            return false;
        }
        OriginLayer layer = (OriginLayer)obj;
        return Objects.equals(this.getRegistryName(), layer.getRegistryName());
    }

    public int hashCode() {
        return Objects.hash(this.getRegistryName());
    }

    @NotNull
    public Optional<Origin> getAutomaticOrigin(Player player) {
        if (!this.autoChoose()) {
            return Optional.empty();
        }
        Registry<Origin> registry = OriginsAPI.getOriginsRegistry();
        List origins = this.origins(player).stream().flatMap(x -> registry.m_6612_(x).stream().filter(Origin::isChoosable)).toList();
        if (this.allowRandom() && origins.isEmpty()) {
            return this.selectRandom(player);
        }
        if (origins.size() > 1) {
            return Optional.empty();
        }
        return origins.stream().findFirst();
    }

    public Optional<Origin> selectRandom(Player player) {
        if (!this.allowRandom()) {
            return Optional.empty();
        }
        Registry<Origin> origins = OriginsAPI.getOriginsRegistry();
        List<Origin> candidates = this.conditionedOrigins.stream().flatMap(x -> x.stream(player)).flatMap(x -> origins.m_6612_(x).stream()).filter(x -> this.allowRandomUnchoosable() || x.isChoosable()).toList();
        if (candidates.isEmpty()) {
            return Optional.empty();
        }
        if (candidates.size() == 1) {
            return Optional.of(candidates.get(0));
        }
        return Optional.of(candidates.get(player.m_21187_().nextInt(candidates.size())));
    }

    public int getOriginOptionCount(Player playerEntity) {
        Registry<Origin> origins = OriginsAPI.getOriginsRegistry();
        long choosableOrigins = this.origins(playerEntity).stream().flatMap(x -> origins.m_6612_(x).stream()).filter(Origin::isChoosable).count();
        if (this.allowRandom() && this.randomOrigins(playerEntity).size() > 0) {
            ++choosableOrigins;
        }
        return Math.toIntExact(choosableOrigins);
    }

    @Override
    public int compareTo(@NotNull OriginLayer o) {
        return Integer.compare(this.order(), o.order());
    }

    public int order() {
        return this.order;
    }

    @Deprecated(forRemoval=true, since="2.3.3.1")
    @Nullable
    public ResourceLocation registryName() {
        return this.getRegistryName();
    }

    public Set<ConditionedOrigin> conditionedOrigins() {
        return this.conditionedOrigins;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Component name() {
        return this.name;
    }

    public Component missingName() {
        return this.missingName;
    }

    public Component missingDescription() {
        return this.missingDescription;
    }

    public boolean allowRandom() {
        return this.allowRandom;
    }

    public boolean allowRandomUnchoosable() {
        return this.allowRandomUnchoosable;
    }

    public Set<ResourceLocation> randomExclusions() {
        return this.randomExclusions;
    }

    @Nullable
    public ResourceLocation defaultOrigin() {
        return this.defaultOrigin;
    }

    public boolean autoChoose() {
        return this.autoChoose;
    }

    public boolean hidden() {
        return this.hidden;
    }

    public GuiTitle title() {
        return this.title;
    }

    public String toString() {
        return "OriginLayer[order=" + this.order + ", conditionedOrigins=" + this.conditionedOrigins + ", enabled=" + this.enabled + ", name=" + this.name + ", missingName=" + this.missingName + ", missingDescription=" + this.missingDescription + ", allowRandom=" + this.allowRandom + ", allowRandomUnchoosable=" + this.allowRandomUnchoosable + ", randomExclusions=" + this.randomExclusions + ", defaultOrigin=" + this.defaultOrigin + ", autoChoose=" + this.autoChoose + ", hidden=" + this.hidden + ", title=" + this.title + "]";
    }
}

