/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.api.capabilities;

import io.github.apace100.origins.component.OriginComponent;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import io.github.edwinmindcraft.origins.common.network.S2CSynchronizeOrigin;
import java.util.Map;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public interface IOriginContainer
extends INBTSerializable<Tag> {
    public static LazyOptional<IOriginContainer> get(@Nullable Entity entity) {
        return entity != null ? entity.getCapability(OriginsAPI.ORIGIN_CONTAINER) : LazyOptional.empty();
    }

    public void setOrigin(OriginLayer var1, Origin var2);

    public Origin getOrigin(OriginLayer var1);

    public boolean hasOrigin(OriginLayer var1);

    default public boolean hasAllOrigins() {
        return OriginsAPI.getActiveLayers().stream().filter(x -> !x.empty(this.getOwner())).allMatch(this::hasOrigin);
    }

    public boolean hadAllOrigins();

    public Map<OriginLayer, Origin> getOrigins();

    public void synchronize();

    public boolean shouldSync();

    public void tick();

    public void validateSynchronization();

    public S2CSynchronizeOrigin getSynchronizationPacket();

    public boolean checkAutoChoosingLayers(boolean var1);

    public void onChosen(Origin var1, boolean var2);

    public void onChosen(boolean var1);

    public void onReload();

    public OriginComponent asLegacyComponent();

    public Player getOwner();
}

