/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.api;

import io.github.edwinmindcraft.calio.api.CalioAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import io.github.edwinmindcraft.origins.api.registry.OriginsDynamicRegistries;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import org.apache.commons.lang3.Validate;

public class OriginsAPI {
    private static final ConcurrentHashMap<ResourceLocation, ResourceLocation> POWER_SOURCE_CACHE = new ConcurrentHashMap();
    public static final String MODID = "origins";
    public static final Capability<IOriginContainer> ORIGIN_CONTAINER = CapabilityManager.get((CapabilityToken)new CapabilityToken<IOriginContainer>(){});

    public static Registry<Origin> getOriginsRegistry(MinecraftServer server) {
        return CalioAPI.getDynamicRegistries(server).get(OriginsDynamicRegistries.ORIGINS_REGISTRY);
    }

    public static Registry<Origin> getOriginsRegistry() {
        return CalioAPI.getDynamicRegistries().get(OriginsDynamicRegistries.ORIGINS_REGISTRY);
    }

    public static Registry<OriginLayer> getLayersRegistry(MinecraftServer server) {
        return CalioAPI.getDynamicRegistries(server).get(OriginsDynamicRegistries.LAYERS_REGISTRY);
    }

    public static Registry<OriginLayer> getLayersRegistry() {
        return CalioAPI.getDynamicRegistries().get(OriginsDynamicRegistries.LAYERS_REGISTRY);
    }

    public static List<OriginLayer> getActiveLayers() {
        return OriginsAPI.getLayersRegistry().m_123024_().filter(OriginLayer::enabled).sorted().toList();
    }

    public static ResourceLocation getPowerSource(Origin origin) {
        ResourceLocation registryName = origin.getRegistryName();
        Validate.notNull((Object)registryName, (String)"Unregistered origins cannot provide powers.", (Object[])new Object[0]);
        return POWER_SOURCE_CACHE.computeIfAbsent(registryName, OriginsAPI::createPowerSource);
    }

    public static ResourceLocation getPowerSource(ResourceLocation origin) {
        Validate.notNull((Object)origin, (String)"Unregistered origins cannot provide powers.", (Object[])new Object[0]);
        return POWER_SOURCE_CACHE.computeIfAbsent(origin, OriginsAPI::createPowerSource);
    }

    private static ResourceLocation createPowerSource(ResourceLocation key) {
        return new ResourceLocation(key.m_135827_(), key.m_135815_());
    }
}

