/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.calio.common.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import io.github.edwinmindcraft.calio.api.CalioAPI;
import io.github.edwinmindcraft.calio.api.event.CalioDynamicRegistryEvent;
import io.github.edwinmindcraft.calio.api.event.DynamicRegistrationEvent;
import io.github.edwinmindcraft.calio.api.registry.DynamicEntryFactory;
import io.github.edwinmindcraft.calio.api.registry.DynamicEntryValidator;
import io.github.edwinmindcraft.calio.api.registry.ICalioDynamicRegistryManager;
import io.github.edwinmindcraft.calio.client.util.ClientHelper;
import io.github.edwinmindcraft.calio.common.CalioConfig;
import io.github.edwinmindcraft.calio.common.network.CalioNetwork;
import io.github.edwinmindcraft.calio.common.network.packet.S2CDynamicRegistryPacket;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CalioDynamicRegistryManager
implements ICalioDynamicRegistryManager {
    private static final Gson GSON = new GsonBuilder().create();
    private static final int FILE_SUFFIX_LENGTH = ".json".length();
    private static final Map<RegistryAccess, CalioDynamicRegistryManager> INSTANCES = new ConcurrentHashMap<RegistryAccess, CalioDynamicRegistryManager>();
    private static CalioDynamicRegistryManager clientInstance = null;
    private static CalioDynamicRegistryManager serverInstance = null;
    private boolean lock = false;
    private final Map<ResourceKey<?>, MappedRegistry<?>> registries = new HashMap();
    private final Map<ResourceKey<?>, RegistryDefinition<?>> definitions = new HashMap();
    private final Map<ResourceKey<?>, ReloadFactory<?>> factories = new HashMap();
    private final Map<ResourceKey<?>, Validator<?>> validators = new HashMap();
    private final List<ResourceKey<?>> validatorOrder;

    public CalioDynamicRegistryManager() {
        int prevSize;
        MinecraftForge.EVENT_BUS.post((Event)new CalioDynamicRegistryEvent.Initialize(this));
        this.lock = true;
        ArrayList<Object> handled = new ArrayList<Object>();
        do {
            prevSize = handled.size();
            for (Validator<?> validator : this.validators.values()) {
                if (handled.contains(validator.key()) || !Arrays.stream(validator.dependencies()).allMatch(handled::contains)) continue;
                handled.add(validator.key());
            }
        } while (prevSize != handled.size());
        if (handled.size() != this.validators.size()) {
            throw new IllegalStateException("Some validators have missing or circular dependencies: [" + String.join((CharSequence)",", this.validators.keySet().stream().filter(x -> !handled.contains(x)).map(x -> x.m_135782_().toString()).collect(Collectors.toSet())) + "]");
        }
        for (ResourceKey resourceKey : this.factories.keySet()) {
            if (handled.contains(resourceKey)) continue;
            handled.add(resourceKey);
        }
        this.validatorOrder = ImmutableList.copyOf(handled);
    }

    @NotNull
    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier barrier, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller preparationsProfiler, @NotNull ProfilerFiller reloadProfiler, @NotNull Executor preparationsExecutor, @NotNull Executor reloadExecutor) {
        return ((CompletableFuture)this.prepare(resourceManager, preparationsExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).m_6769_(arg_0))).thenCompose(x -> this.reload((Map<ResourceKey<?>, Map<ResourceLocation, List<JsonElement>>>)x, reloadExecutor));
    }

    private CompletableFuture<Map<ResourceKey<?>, Map<ResourceLocation, List<JsonElement>>>> prepare(ResourceManager resourceManager, Executor executor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        CompletableFuture[] completableFutures = (CompletableFuture[])this.factories.entrySet().stream().map(x -> CompletableFuture.runAsync(() -> map.put((ResourceKey)x.getKey(), ((ReloadFactory)x.getValue()).prepare(resourceManager)), executor)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(completableFutures).thenApplyAsync(x -> map, executor);
    }

    private CompletableFuture<Void> reload(Map<ResourceKey<?>, Map<ResourceLocation, List<JsonElement>>> input, Executor executor) {
        MinecraftForge.EVENT_BUS.post((Event)new CalioDynamicRegistryEvent.Reload(this));
        input.keySet().forEach(x -> this.reset((ResourceKey)x));
        ConcurrentHashMap map = new ConcurrentHashMap();
        CompletableFuture[] completableFutures = (CompletableFuture[])this.factories.entrySet().stream().map(x -> CompletableFuture.runAsync(() -> map.put((ResourceKey)x.getKey(), ((ReloadFactory)x.getValue()).reload((Map)input.get(x.getKey()))), executor)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(completableFutures).thenAcceptAsync(x -> {
            for (ResourceKey<?> resourceKey : this.validatorOrder) {
                this.validate(resourceKey, this.validators.get(resourceKey), (Map)map.get(resourceKey));
            }
            MinecraftForge.EVENT_BUS.post((Event)new CalioDynamicRegistryEvent.LoadComplete(this));
            this.dump();
        }, executor);
    }

    public void synchronize(PacketDistributor.PacketTarget target) {
        for (S2CDynamicRegistryPacket.Play<?> packet : S2CDynamicRegistryPacket.Play.create(this)) {
            CalioNetwork.CHANNEL.send(target, packet);
        }
    }

    public <T> Codec<T> getCodec(ResourceKey<Registry<T>> key) {
        return this.definitions.get(key).codec();
    }

    public void dump() {
        if (!((Boolean)CalioConfig.COMMON.logging.get()).booleanValue()) {
            return;
        }
        CalioAPI.LOGGER.info("Calio dynamic registry dump:");
        this.registries.values().forEach(CalioDynamicRegistryManager::dumpRegistry);
    }

    private static <T> void dumpRegistry(Registry<T> reg) {
        CalioAPI.LOGGER.info("{}: {} entries", (Object)reg.m_123023_().m_135782_(), (Object)reg.m_6566_().size());
        if (((Boolean)CalioConfig.COMMON.reducedLogging.get()).booleanValue()) {
            return;
        }
        for (ResourceLocation resourceLocation : reg.m_6566_()) {
            Optional<Holder> holder = reg.m_203636_(ResourceKey.m_135785_((ResourceKey)reg.m_123023_(), (ResourceLocation)resourceLocation)).filter(Holder::m_203633_);
            CalioAPI.LOGGER.info("  {}: {}", (Object)resourceLocation, (Object)holder.map(x -> x.m_203334_().toString()).orElse("Missing"));
        }
    }

    private <T> void validate(ResourceKey<Registry<T>> key, @Nullable Validator<T> validator, Map<ResourceLocation, T> entries) {
        WritableRegistry registry = this.get(key);
        entries.forEach((location, t) -> {
            ResourceKey resourceKey = ResourceKey.m_135785_((ResourceKey)key, (ResourceLocation)location);
            if (validator != null) {
                t = validator.validate(resourceKey, t, this);
            }
            if (t != null) {
                IForgeRegistryEntry re;
                if (t instanceof IForgeRegistryEntry && (re = (IForgeRegistryEntry)t).getRegistryName() == null) {
                    re.setRegistryName(location);
                }
                registry.m_203505_(resourceKey, t, Lifecycle.experimental());
            }
        });
    }

    public static boolean isServerContext(RegistryAccess access) {
        return (Boolean)DistExecutor.unsafeRunForDist(() -> () -> ClientHelper.isServerContext(access), () -> () -> true);
    }

    public static CalioDynamicRegistryManager getInstance(RegistryAccess server) {
        if (CalioDynamicRegistryManager.isServerContext(server)) {
            return CalioDynamicRegistryManager.addInstance(server);
        }
        if (clientInstance == null) {
            CalioDynamicRegistryManager.initializeClient();
        }
        return clientInstance;
    }

    private static CalioDynamicRegistryManager addInstance(RegistryAccess server) {
        if (serverInstance == null) {
            serverInstance = new CalioDynamicRegistryManager();
        }
        return serverInstance;
    }

    public static void removeInstance(RegistryAccess server) {
        serverInstance = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initializeClient() {
        clientInstance = new CalioDynamicRegistryManager();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setClientInstance(CalioDynamicRegistryManager clientInstance) {
        CalioDynamicRegistryManager.clientInstance = clientInstance;
    }

    public static CalioDynamicRegistryManager decode(FriendlyByteBuf buffer) {
        int registryCount = buffer.m_130242_();
        CalioDynamicRegistryManager manager = new CalioDynamicRegistryManager();
        for (int i = 0; i < registryCount; ++i) {
            CalioDynamicRegistryManager.readRegistry(buffer, manager);
        }
        return manager;
    }

    private static <T> void readRegistry(FriendlyByteBuf buffer, CalioDynamicRegistryManager manager) {
        ResourceKey key = ResourceKey.m_135788_((ResourceLocation)buffer.m_130281_());
        int count = buffer.m_130242_();
        WritableRegistry<T> registry = manager.get(key);
        Codec<?> codec = manager.definitions.get(key).codec();
        for (int i = 0; i < count; ++i) {
            ResourceKey objectKey = ResourceKey.m_135785_((ResourceKey)key, (ResourceLocation)buffer.m_130281_());
            Object decode = buffer.m_130057_(codec);
            if (decode instanceof IForgeRegistryEntry) {
                IForgeRegistryEntry fre = (IForgeRegistryEntry)decode;
                fre.setRegistryName(objectKey.m_135782_());
            }
            registry.m_203384_(OptionalInt.empty(), objectKey, decode, Lifecycle.stable());
        }
    }

    @Override
    public <T> void add(@NotNull ResourceKey<Registry<T>> key, @Nullable Consumer<BiConsumer<ResourceKey<T>, T>> builtin, Codec<T> codec, @Nullable Supplier<ResourceLocation> defaultValue) {
        Validate.isTrue((!this.lock ? 1 : 0) != 0, (String)"Cannot add registries after the dynamic registry manager has initialized", (Object[])new Object[0]);
        if (this.definitions.containsKey(key)) {
            throw new IllegalArgumentException("Registry for key " + key + " is already added.");
        }
        RegistryDefinition value = new RegistryDefinition(builtin, codec, defaultValue);
        this.definitions.put(key, value);
        this.reset(key);
        this.registries.computeIfAbsent(key, k -> value.newRegistry(key));
    }

    @Override
    public <T> void addReload(ResourceKey<Registry<T>> key, String directory, DynamicEntryFactory<T> factory) {
        Validate.isTrue((!this.lock ? 1 : 0) != 0, (String)"Cannot add reload factories after the dynamic registry manager has initialized", (Object[])new Object[0]);
        if (this.factories.containsKey(key)) {
            throw new IllegalArgumentException("Reload factory for registry " + key + " is already added.");
        }
        this.factories.put(key, new ReloadFactory<T>(directory, factory));
    }

    @Override
    public <T> void addValidation(ResourceKey<Registry<T>> key, DynamicEntryValidator<T> validator, Class<T> eventClass, ResourceKey<?> ... after) {
        Validate.isTrue((!this.lock ? 1 : 0) != 0, (String)"Cannot add validators after the dynamic registry manager has initialized", (Object[])new Object[0]);
        if (this.validators.containsKey(key)) {
            throw new IllegalArgumentException("Reload factory for registry " + key + " is already added.");
        }
        this.validators.put(key, new Validator<T>(key, validator, eventClass, after));
    }

    public Set<ResourceKey<Registry<?>>> getRegistryNames() {
        return this.definitions.keySet();
    }

    @Override
    public <T> WritableRegistry<T> reset(ResourceKey<Registry<T>> key) {
        this.registries.remove(key);
        MappedRegistry<?> mappedRegistry = this.definitions.get(key).newRegistry(key);
        this.registries.put(key, mappedRegistry);
        return mappedRegistry;
    }

    @Override
    @NotNull
    public <T> WritableRegistry<T> get(@NotNull ResourceKey<Registry<T>> key) {
        MappedRegistry<?> registry = this.registries.get(key);
        if (registry == null) {
            throw new IllegalArgumentException("Registry " + key + " was missing.");
        }
        return registry;
    }

    @Override
    public <T> Optional<WritableRegistry<T>> getOrEmpty(ResourceKey<Registry<T>> key) {
        return Optional.ofNullable((WritableRegistry)this.registries.get(key));
    }

    @Override
    public <T> T register(ResourceKey<Registry<T>> registry, ResourceKey<T> name, T value) {
        if (!name.m_135783_(registry)) {
            throw new IllegalArgumentException("Registry key " + name + " doesn't target registry " + registry + ".");
        }
        return null;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.registries.size());
        this.registries.forEach((registryKey, objects) -> this.writeRegistry((ResourceKey<?>)registryKey, (Registry)objects, buffer));
    }

    public <T> void writeRegistry(ResourceKey<?> key, Registry<T> registry, FriendlyByteBuf buffer) {
        Codec<?> codec = this.definitions.get(key).codec();
        buffer.m_130085_(key.m_135782_());
        ArrayList entries = new ArrayList(registry.m_183450_());
        for (ResourceLocation entry2 : registry.m_6566_()) {
            Optional<Holder> holder = registry.m_203636_(ResourceKey.m_135785_((ResourceKey)registry.m_123023_(), (ResourceLocation)entry2)).filter(Holder::m_203633_);
            holder.ifPresent(tHolder -> entries.add(Pair.of((Object)entry2, (Object)tHolder.m_203334_())));
        }
        buffer.m_130130_(entries.size());
        entries.forEach(entry -> {
            buffer.m_130085_((ResourceLocation)entry.getKey());
            buffer.m_130059_(codec, entry.getValue());
        });
    }

    private record Validator<T>(ResourceKey<Registry<T>> key, DynamicEntryValidator<T> validator, Class<T> eventClass, ResourceKey<?>[] dependencies) {
        public T validate(ResourceKey<T> entry, T input, ICalioDynamicRegistryManager manager) {
            DataResult<T> result = this.validator().validate(entry.m_135782_(), input, manager);
            if (result.error().isPresent()) {
                CalioAPI.LOGGER.error("Validation for {} failed with error: {}", entry, result.error().get());
                return null;
            }
            Object t = result.getOrThrow(false, s -> {});
            if (this.eventClass() != null) {
                DynamicRegistrationEvent<T> event = new DynamicRegistrationEvent<T>(this.eventClass(), entry.m_135782_(), input);
                if (MinecraftForge.EVENT_BUS.post(event)) {
                    if (event.getCancellationReason() != null) {
                        CalioAPI.LOGGER.info("Registration of {} was cancelled: {}", entry, (Object)event.getCancellationReason());
                    }
                    return null;
                }
                return event.getNewEntry();
            }
            return (T)t;
        }
    }

    private record RegistryDefinition<T>(Consumer<BiConsumer<ResourceKey<T>, T>> builtin, Codec<T> codec, @Nullable Supplier<ResourceLocation> defaultValue) {
        public MappedRegistry<T> newRegistry(ResourceKey<Registry<T>> key) {
            MappedRegistry registry;
            ResourceLocation defaultKey = this.defaultValue() != null ? this.defaultValue().get() : null;
            Object object = registry = defaultKey == null ? new MappedRegistry(key, Lifecycle.experimental(), null) : new DefaultedRegistry(defaultKey.toString(), key, Lifecycle.experimental(), null);
            if (this.builtin() != null) {
                this.builtin().accept((rl, value) -> registry.m_203505_(rl, value, Lifecycle.experimental()));
            }
            return registry;
        }
    }

    private record ReloadFactory<T>(String directory, DynamicEntryFactory<T> factory) {
        public Map<ResourceLocation, List<JsonElement>> prepare(ResourceManager resourceManager) {
            HashMap map = Maps.newHashMap();
            int i = this.directory().length() + 1;
            HashSet resourcesHandled = new HashSet();
            for (ResourceLocation identifier : resourceManager.m_6540_(this.directory(), stringx -> stringx.endsWith(".json"))) {
                String string = identifier.m_135815_();
                ResourceLocation identifier2 = new ResourceLocation(identifier.m_135827_(), string.substring(i, string.length() - FILE_SUFFIX_LENGTH));
                resourcesHandled.clear();
                try {
                    resourceManager.m_7396_(identifier).forEach(resource -> {
                        if (!resourcesHandled.contains(resource.m_7816_())) {
                            resourcesHandled.add(resource.m_7816_());
                            try (Resource resource2 = resource;
                                 InputStream inputStream = resource.m_6679_();
                                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                                JsonElement jsonElement = (JsonElement)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonElement.class);
                                if (jsonElement != null) {
                                    if (map.containsKey(identifier2)) {
                                        ((List)map.get(identifier2)).add(jsonElement);
                                    } else {
                                        LinkedList<JsonElement> elementList = new LinkedList<JsonElement>();
                                        elementList.add(jsonElement);
                                        map.put(identifier2, elementList);
                                    }
                                } else {
                                    CalioAPI.LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)identifier2, (Object)identifier);
                                }
                            }
                            catch (JsonParseException | IOException | IllegalArgumentException var68) {
                                CalioAPI.LOGGER.error("Couldn't parse data file {} from {}", (Object)identifier2, (Object)identifier, (Object)var68);
                            }
                        }
                    });
                }
                catch (IOException e) {
                    CalioAPI.LOGGER.error("Couldn't parse data file {} from {}", (Object)identifier2, (Object)identifier, (Object)e);
                }
            }
            return map;
        }

        public Map<ResourceLocation, T> reload(Map<ResourceLocation, List<JsonElement>> input) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            input.forEach((location, jsonElements) -> this.factory().create((ResourceLocation)location, (List<JsonElement>)jsonElements).forEach((arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1)));
            return builder.build();
        }
    }
}

