/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.calio.common.network.packet;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import io.github.edwinmindcraft.calio.api.CalioAPI;
import io.github.edwinmindcraft.calio.common.network.CalioNetwork;
import io.github.edwinmindcraft.calio.common.network.packet.C2SAcknowledgePacket;
import io.github.edwinmindcraft.calio.common.registry.CalioDynamicRegistryManager;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class S2CDynamicRegistryPacket<T> {
    private final ResourceKey<Registry<T>> key;
    private final Registry<T> registry;
    private final Codec<T> codec;
    private final int start;
    private final int count;

    public S2CDynamicRegistryPacket(ResourceKey<Registry<T>> key, Registry<T> registry, Codec<T> codec, int start, int count) {
        this.key = key;
        this.registry = registry;
        this.codec = codec;
        this.start = start;
        this.count = count;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.key.m_135782_());
        List<Holder.Reference> references = this.registry.m_203611_().filter(Holder.Reference::m_203633_).toList();
        buffer.m_130130_(this.start);
        buffer.m_130130_(this.count);
        for (int i = this.start; i < this.start + this.count; ++i) {
            Holder.Reference entry = references.get(i);
            buffer.writeInt(this.registry.m_7447_(entry.m_203334_()));
            buffer.m_130085_(entry.m_205785_().m_135782_());
            buffer.m_130059_(this.codec, entry.m_203334_());
        }
    }

    private static <T, V extends S2CDynamicRegistryPacket<T>> List<V> splitPackets(ResourceKey<Registry<T>> key, CalioDynamicRegistryManager drm, Builder<T, V> builder, int size) {
        WritableRegistry<T> registry = drm.get(key);
        Codec<T> codec = drm.getCodec(key);
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130085_(key.m_135782_());
        List<Holder.Reference> references = registry.m_203611_().filter(Holder.Reference::m_203633_).toList();
        ArrayList<V> packets = new ArrayList<V>();
        buffer.writeInt(0);
        buffer.writeInt(0);
        int overhead = buffer.writerIndex();
        int start = 0;
        for (int i = 0; i < references.size(); ++i) {
            Holder.Reference entry = references.get(i);
            buffer.writeInt(registry.m_7447_(entry.m_203334_()));
            buffer.m_130085_(entry.m_205785_().m_135782_());
            buffer.m_130059_(codec, entry.m_203334_());
            if (buffer.writerIndex() < size) continue;
            packets.add(builder.apply(key, (Registry<T>)registry, codec, start, i - start));
            start = i;
            buffer.writerIndex(overhead);
        }
        buffer.release();
        packets.add(builder.apply(key, (Registry<T>)registry, codec, start, references.size() - start));
        return packets;
    }

    private static <T, V extends S2CDynamicRegistryPacket<T>> V decodeWithBuilder(FriendlyByteBuf buffer, Builder<T, V> decoder) {
        CalioDynamicRegistryManager cdrm = CalioDynamicRegistryManager.getInstance(null);
        ResourceKey registryKey = ResourceKey.m_135788_((ResourceLocation)buffer.m_130281_());
        MappedRegistry registry = new MappedRegistry(registryKey, Lifecycle.experimental(), null);
        Codec codec = cdrm.getCodec(registryKey);
        int start = buffer.m_130242_();
        int count = buffer.m_130242_();
        for (int i = 0; i < count; ++i) {
            int index = buffer.readInt();
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)registryKey, (ResourceLocation)buffer.m_130281_());
            Object value = buffer.m_130057_(codec);
            registry.m_203704_(index, key, value, Lifecycle.experimental());
        }
        return decoder.apply(registryKey, registry, codec, start, count);
    }

    public void handle(Supplier<NetworkEvent.Context> handler) {
        handler.get().enqueueWork(() -> {
            CalioDynamicRegistryManager instance = CalioDynamicRegistryManager.getInstance(null);
            WritableRegistry<T> target = this.start == 0 ? instance.reset(this.key) : instance.get(this.key);
            for (Map.Entry entry : this.registry.m_6579_()) {
                Object patt4596$temp = entry.getValue();
                if (patt4596$temp instanceof IForgeRegistryEntry) {
                    IForgeRegistryEntry fre = (IForgeRegistryEntry)patt4596$temp;
                    fre.setRegistryName(((ResourceKey)entry.getKey()).m_135782_());
                }
                target.m_203384_(OptionalInt.of(this.registry.m_7447_(entry.getValue())), (ResourceKey)entry.getKey(), entry.getValue(), Lifecycle.experimental());
            }
            instance.dump();
        });
        if (this instanceof Login) {
            CalioNetwork.CHANNEL.reply((Object)new C2SAcknowledgePacket(), handler.get());
        }
        handler.get().setPacketHandled(true);
    }

    @FunctionalInterface
    public static interface Builder<T, V extends S2CDynamicRegistryPacket<T>> {
        public V apply(ResourceKey<Registry<T>> var1, Registry<T> var2, Codec<T> var3, int var4, int var5);
    }

    public static final class Login<T>
    extends S2CDynamicRegistryPacket<T>
    implements IntSupplier {
        public int loginIndex;

        public Login(ResourceKey<Registry<T>> key, Registry<T> registry, Codec<T> codec, int start, int count) {
            super(key, registry, codec, start, count);
        }

        public int getLoginIndex() {
            return this.loginIndex;
        }

        public void setLoginIndex(int loginIndex) {
            this.loginIndex = loginIndex;
        }

        @Override
        public int getAsInt() {
            return this.loginIndex;
        }

        public static <T> Login<T> decode(FriendlyByteBuf buf) {
            return S2CDynamicRegistryPacket.decodeWithBuilder(buf, Login::new);
        }

        private static <T> List<Login<T>> split(ResourceKey<Registry<?>> key, CalioDynamicRegistryManager drm, int size) {
            return S2CDynamicRegistryPacket.splitPackets(key, drm, Login::new, size);
        }

        public static List<Pair<String, Login>> create(boolean isLocal) {
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                CalioDynamicRegistryManager drm = (CalioDynamicRegistryManager)CalioAPI.getDynamicRegistries(ServerLifecycleHooks.getCurrentServer());
                for (ResourceKey<Registry<?>> registryName : drm.getRegistryNames()) {
                    List splitPackets = Login.split(registryName, drm, 0x100000);
                    for (int i = 0; i < splitPackets.size(); ++i) {
                        builder.add((Object)Pair.of((Object)("CALIO-S2CLDRP-" + registryName.m_135782_() + "-" + i), splitPackets.get(i)));
                    }
                }
                return builder.build();
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw t;
            }
        }
    }

    public static final class Play<T>
    extends S2CDynamicRegistryPacket<T> {
        public Play(ResourceKey<Registry<T>> key, Registry<T> registry, Codec<T> codec, int start, int count) {
            super(key, registry, codec, start, count);
        }

        public static <T> Play<T> decode(FriendlyByteBuf buf) {
            return S2CDynamicRegistryPacket.decodeWithBuilder(buf, Play::new);
        }

        private static <T> List<Play<T>> split(ResourceKey<Registry<?>> key, CalioDynamicRegistryManager drm, int size) {
            return S2CDynamicRegistryPacket.splitPackets(key, drm, Play::new, size);
        }

        public static List<Play<?>> create(CalioDynamicRegistryManager manager) {
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (ResourceKey<Registry<?>> registryName : manager.getRegistryNames()) {
                    for (Play splitPacket : Play.split(registryName, manager, 0x100000)) {
                        builder.add(splitPacket);
                    }
                }
                return builder.build();
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw t;
            }
        }
    }
}

