/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.calio.common.network;

import io.github.edwinmindcraft.calio.api.CalioAPI;
import io.github.edwinmindcraft.calio.common.network.packet.C2SAcknowledgePacket;
import io.github.edwinmindcraft.calio.common.network.packet.S2CDataObjectRegistryPacket;
import io.github.edwinmindcraft.calio.common.network.packet.S2CDynamicRegistryPacket;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.HandshakeHandler;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class CalioNetwork {
    public static final String NETWORK_VERSION = "1.2";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)CalioAPI.resource("channel"), () -> "1.2", "1.2"::equals, "1.2"::equals);

    private static <T, R> Function<T, R> failsafe(Function<T, R> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Throwable err) {
                err.printStackTrace();
                throw err;
            }
        };
    }

    private static <T, R> BiConsumer<T, R> failsafe(BiConsumer<T, R> function) {
        return (t, r) -> {
            try {
                function.accept(t, r);
            }
            catch (Throwable err) {
                err.printStackTrace();
                throw err;
            }
        };
    }

    public static void register() {
        int index = 0;
        CHANNEL.messageBuilder(C2SAcknowledgePacket.class, index++, NetworkDirection.LOGIN_TO_SERVER).decoder(CalioNetwork.failsafe(C2SAcknowledgePacket::decode)).encoder(CalioNetwork.failsafe(C2SAcknowledgePacket::encode)).consumer(CalioNetwork.failsafe(HandshakeHandler.indexFirst((handler, c2SAcknowledgePacket, context) -> c2SAcknowledgePacket.handle(context)))).loginIndex(C2SAcknowledgePacket::getLoginIndex, C2SAcknowledgePacket::setLoginIndex).add();
        CHANNEL.messageBuilder(S2CDynamicRegistryPacket.Login.class, index++, NetworkDirection.LOGIN_TO_CLIENT).decoder(CalioNetwork.failsafe(S2CDynamicRegistryPacket.Login::decode)).encoder(CalioNetwork.failsafe(S2CDynamicRegistryPacket::encode)).consumer(CalioNetwork.failsafe(S2CDynamicRegistryPacket::handle)).loginIndex(S2CDynamicRegistryPacket.Login::getLoginIndex, S2CDynamicRegistryPacket.Login::setLoginIndex).buildLoginPacketList(S2CDynamicRegistryPacket.Login::create).add();
        CHANNEL.messageBuilder(S2CDataObjectRegistryPacket.class, index++, NetworkDirection.PLAY_TO_CLIENT).decoder(CalioNetwork.failsafe(S2CDataObjectRegistryPacket::decode)).encoder(CalioNetwork.failsafe(S2CDataObjectRegistryPacket::encode)).consumer(CalioNetwork.failsafe(S2CDataObjectRegistryPacket::handle)).add();
        CHANNEL.messageBuilder(S2CDynamicRegistryPacket.Play.class, index++, NetworkDirection.PLAY_TO_CLIENT).decoder(CalioNetwork.failsafe(S2CDynamicRegistryPacket.Play::decode)).encoder(CalioNetwork.failsafe(S2CDynamicRegistryPacket::encode)).consumer(CalioNetwork.failsafe(S2CDynamicRegistryPacket::handle)).add();
        CalioAPI.LOGGER.debug("Registered {} packets", (Object)index);
    }
}

