/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.calio.common.ability;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import io.github.edwinmindcraft.calio.api.CalioAPI;
import io.github.edwinmindcraft.calio.api.ability.IAbilityHolder;
import io.github.edwinmindcraft.calio.api.ability.PlayerAbility;
import io.github.edwinmindcraft.calio.api.registry.PlayerAbilities;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbilityHolder
implements ICapabilitySerializable<Tag>,
IAbilityHolder {
    public static final ResourceLocation ID = CalioAPI.resource("ability_holder");
    private final Multimap<PlayerAbility, ResourceLocation> abilities;
    private final Set<PlayerAbility> toTick;
    private final Player player;
    private final LazyOptional<IAbilityHolder> thisOptional = LazyOptional.of(() -> this);

    public AbilityHolder(Player player) {
        this.player = player;
        this.abilities = Multimaps.newMultimap(new ConcurrentHashMap(), () -> Collections.newSetFromMap(new ConcurrentHashMap()));
        this.toTick = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    @Override
    public void grant(@NotNull PlayerAbility ability, @NotNull ResourceLocation source) {
        this.abilities.put((Object)ability, (Object)source);
    }

    @Override
    public void revoke(@NotNull PlayerAbility ability, @NotNull ResourceLocation source) {
        boolean flag = this.abilities.remove((Object)ability, (Object)source);
        if (flag && !this.abilities.containsKey((Object)ability)) {
            this.toTick.add(ability);
        }
    }

    @Override
    public boolean has(@NotNull PlayerAbility ability, @NotNull ResourceLocation source) {
        return this.abilities.containsEntry((Object)ability, (Object)source);
    }

    @Override
    public boolean has(@NotNull PlayerAbility ability) {
        return this.abilities.containsKey((Object)ability);
    }

    @Override
    public boolean applyRemovals() {
        boolean flag = false;
        for (PlayerAbility ability : this.toTick) {
            if (this.has(ability) || !ability.has(this.player)) continue;
            ability.revoke(this.player);
            flag = true;
        }
        this.toTick.clear();
        return flag;
    }

    @Override
    public boolean applyAdditions() {
        boolean flag = false;
        for (PlayerAbility ability : this.abilities.keySet()) {
            if (ability.has(this.player) || !this.has(ability)) continue;
            ability.grant(this.player);
            flag = true;
        }
        return flag;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return CalioAPI.ABILITY_HOLDER.orEmpty(cap, this.thisOptional);
    }

    public Tag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        for (PlayerAbility key : this.abilities.keySet()) {
            ListTag ls = new ListTag();
            for (ResourceLocation resourceLocation : this.abilities.get((Object)key)) {
                ls.add((Object)StringTag.m_129297_((String)resourceLocation.toString()));
            }
            tag.m_128365_(key.getRegistryName().toString(), (Tag)ls);
        }
        return tag;
    }

    public void deserializeNBT(Tag nbt) {
        CompoundTag tag = (CompoundTag)nbt;
        for (String key : tag.m_128431_()) {
            PlayerAbility value = (PlayerAbility)PlayerAbilities.REGISTRY.get().getValue(ResourceLocation.m_135820_((String)key));
            if (value == null) continue;
            ListTag list = tag.m_128437_(key, 8);
            for (Tag t : list) {
                ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)t.m_7916_());
                if (resourceLocation == null) continue;
                this.grant(value, resourceLocation);
            }
        }
    }
}

