/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.calio.common;

import io.github.apace100.calio.Calio;
import io.github.apace100.calio.registry.DataObjectRegistry;
import io.github.apace100.calio.util.OrderedResourceListeners;
import io.github.edwinmindcraft.calio.api.CalioAPI;
import io.github.edwinmindcraft.calio.api.ability.IAbilityHolder;
import io.github.edwinmindcraft.calio.common.ability.AbilityHolder;
import io.github.edwinmindcraft.calio.common.registry.CalioDynamicRegistryManager;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="calio")
public class CalioEventHandler {
    @SubscribeEvent
    public static void onDatapack(OnDatapackSyncEvent event) {
        PacketDistributor.PacketTarget target = event.getPlayer() == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> ((OnDatapackSyncEvent)event).getPlayer());
        CalioDynamicRegistryManager.getInstance((RegistryAccess)event.getPlayerList().m_7873_().m_206579_()).synchronize(target);
        if (event.getPlayer() != null) {
            DataObjectRegistry.performAutoSync(event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onServerReload(AddReloadListenerEvent event) {
        CalioDynamicRegistryManager instance = CalioDynamicRegistryManager.getInstance(event.getServerResources().f_206849_.f_144569_);
        event.addListener((PreparableReloadListener)instance);
        OrderedResourceListeners.orderedList().forEach(arg_0 -> ((AddReloadListenerEvent)event).addListener(arg_0));
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        CalioAPI.LOGGER.info("Removing Dynamic Registries for: " + event.getServer());
        CalioDynamicRegistryManager.removeInstance((RegistryAccess)event.getServer().m_206579_());
    }

    @SubscribeEvent
    public static void onCapability(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(AbilityHolder.ID, (ICapabilityProvider)new AbilityHolder(player));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void playerFirstTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && CalioAPI.getAbilityHolder((Entity)event.player).map(IAbilityHolder::applyRemovals).orElse(false).booleanValue()) {
            event.player.m_6885_();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && CalioAPI.getAbilityHolder((Entity)event.player).map(IAbilityHolder::applyAdditions).orElse(false).booleanValue()) {
            event.player.m_6885_();
        }
    }

    @SubscribeEvent
    public static void updateAttributes(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        if (Calio.areEntityAttributesAdditional(stack) && stack.m_41782_() && stack.m_41783_().m_128425_("AttributeModifiers", 9)) {
            event.getModifiers().putAll(stack.m_41720_().getAttributeModifiers(event.getSlotType(), stack));
        }
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        Integer integer;
        List toolTip = event.getToolTip();
        ItemStack itemStack = event.getItemStack();
        if (toolTip.isEmpty() || !Calio.hasNonItalicName(itemStack) || !itemStack.m_41788_()) {
            return;
        }
        Component name = (Component)toolTip.get(0);
        if (name instanceof MutableComponent) {
            MutableComponent mName = (MutableComponent)name;
            mName.m_130938_(style -> style.m_131155_(Boolean.valueOf(false)));
        }
        if (!event.getFlags().m_7050_() && itemStack.m_150930_(Items.f_42573_) && (integer = MapItem.m_151131_((ItemStack)itemStack)) != null) {
            toolTip.add(1, new TextComponent("#" + integer).m_130940_(ChatFormatting.GRAY));
        }
    }
}

