/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.calio.api.registry;

import com.mojang.serialization.Codec;
import io.github.edwinmindcraft.calio.api.registry.DynamicEntryFactory;
import io.github.edwinmindcraft.calio.api.registry.DynamicEntryValidator;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ICalioDynamicRegistryManager
extends PreparableReloadListener {
    default public <T> void addVanilla(@NotNull ResourceKey<Registry<T>> key, @NotNull Supplier<Registry<T>> builtin, Codec<T> codec) {
        Validate.notNull(builtin, (String)("Registry " + key.m_135782_() + " has no builtin, use add instead."), (Object[])new Object[0]);
        this.add(key, consumer -> ((Registry)builtin.get()).m_6579_().forEach(entry -> consumer.accept((ResourceKey)entry.getKey(), entry.getValue())), codec, () -> {
            ResourceLocation resourceLocation;
            Object patt1711$temp = builtin.get();
            if (patt1711$temp instanceof DefaultedRegistry) {
                DefaultedRegistry def = (DefaultedRegistry)patt1711$temp;
                resourceLocation = def.m_122315_();
            } else {
                resourceLocation = null;
            }
            return resourceLocation;
        });
    }

    default public <T extends IForgeRegistryEntry<T>> void addForge(@NotNull ResourceKey<Registry<T>> key, @NotNull Supplier<IForgeRegistry<T>> builtin, Codec<T> codec) {
        Validate.notNull(builtin, (String)("Registry " + key.m_135782_() + " has no builtin, use add instead."), (Object[])new Object[0]);
        this.add(key, consumer -> ((IForgeRegistry)builtin.get()).getEntries().forEach(entry -> consumer.accept((ResourceKey)entry.getKey(), (IForgeRegistryEntry)entry.getValue())), codec, () -> ((IForgeRegistry)builtin.get()).getDefaultKey());
    }

    public <T> void add(@NotNull ResourceKey<Registry<T>> var1, @Nullable Consumer<BiConsumer<ResourceKey<T>, T>> var2, Codec<T> var3, @Nullable Supplier<ResourceLocation> var4);

    default public <T> void add(@NotNull ResourceKey<Registry<T>> key, @Nullable Consumer<BiConsumer<ResourceKey<T>, T>> builtin, Codec<T> codec) {
        this.add(key, builtin, codec, null);
    }

    default public <T> void add(@NotNull ResourceKey<Registry<T>> key, Codec<T> codec) {
        this.add(key, null, codec);
    }

    public <T> void addReload(ResourceKey<Registry<T>> var1, String var2, DynamicEntryFactory<T> var3);

    public <T> void addValidation(ResourceKey<Registry<T>> var1, DynamicEntryValidator<T> var2, @Nullable Class<T> var3, ResourceKey<?> ... var4);

    default public <T> void addValidation(ResourceKey<Registry<T>> key, DynamicEntryValidator<T> validator, ResourceKey<?> ... after) {
        this.addValidation(key, validator, (Class<T>)null, after);
    }

    public <T> WritableRegistry<T> reset(ResourceKey<Registry<T>> var1);

    @NotNull
    public <T> WritableRegistry<T> get(@NotNull ResourceKey<Registry<T>> var1);

    public <T> Optional<WritableRegistry<T>> getOrEmpty(ResourceKey<Registry<T>> var1);

    public <T> T register(ResourceKey<Registry<T>> var1, ResourceKey<T> var2, T var3);
}

