/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.calio.api.network.primitives;

import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;

public class IntegerCodec
implements PrimitiveCodec<Integer> {
    public <T> DataResult<Integer> read(DynamicOps<T> ops, T input) {
        DataResult base = ops.getNumberValue(input).map(Number::intValue);
        if (base.error().isEmpty()) {
            return base;
        }
        if (input instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)input;
            try {
                return DataResult.success((Object)primitive.getAsInt());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return base;
    }

    public <T> T write(DynamicOps<T> ops, Integer value) {
        return (T)ops.createInt(value.intValue());
    }
}

