/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.calio.api.network.primitives;

import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;

public class FloatCodec
implements PrimitiveCodec<Float> {
    public <T> DataResult<Float> read(DynamicOps<T> ops, T input) {
        DataResult base = ops.getNumberValue(input).map(Number::floatValue);
        if (base.error().isEmpty()) {
            return base;
        }
        if (input instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)input;
            try {
                return DataResult.success((Object)Float.valueOf(primitive.getAsFloat()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return base;
    }

    public <T> T write(DynamicOps<T> ops, Float value) {
        return (T)ops.createFloat(value.floatValue());
    }
}

