/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.calio.api.network.primitives;

import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;

public class DoubleCodec
implements PrimitiveCodec<Double> {
    public <T> DataResult<Double> read(DynamicOps<T> ops, T input) {
        DataResult base = ops.getNumberValue(input).map(Number::doubleValue);
        if (base.error().isEmpty()) {
            return base;
        }
        if (input instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)input;
            try {
                return DataResult.success((Object)primitive.getAsDouble());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return base;
    }

    public <T> T write(DynamicOps<T> ops, Double value) {
        return (T)ops.createDouble(value.doubleValue());
    }
}

