/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.calio.api.network;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.RecordBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.nbt.NbtOps;

public class UnitListCodec<A>
implements Codec<List<A>> {
    private final Codec<A> elementCodec;

    public UnitListCodec(Codec<A> elementCodec) {
        this.elementCodec = elementCodec;
    }

    public <T> DataResult<T> encode(List<A> input, DynamicOps<T> ops, T prefix) {
        if (input.size() == 1 && !(ops instanceof NbtOps)) {
            return this.elementCodec.encode(input.get(0), ops, prefix);
        }
        try {
            ListBuilder builder = ops.listBuilder();
            for (A a : input) {
                builder.add(this.elementCodec.encodeStart(ops, a));
            }
            return builder.build(prefix);
        }
        catch (Exception e) {
            RecordBuilder builder = ops.mapBuilder();
            for (int i = 0; i < input.size(); ++i) {
                builder.add(Integer.toString(i), this.elementCodec.encodeStart(ops, input.get(i)));
            }
            return builder.build(prefix);
        }
    }

    public <T> DataResult<Pair<List<A>, T>> decode(DynamicOps<T> ops, T input) {
        DataResult listDecode;
        DataResult map1;
        DataResult list = ops.getList(input);
        if (list.error().isPresent() && (map1 = ops.getMap(input)).error().isEmpty()) {
            list = map1.flatMap(map -> {
                List<Pair> pairs = map.entries().map(value -> Pair.of((Object)ops.getStringValue(value.getFirst()).flatMap(x -> {
                    try {
                        return DataResult.success((Object)Integer.valueOf(x));
                    }
                    catch (NumberFormatException e) {
                        return DataResult.error((String)("At element: " + x + ": " + e.getMessage()));
                    }
                }), (Object)value.getSecond())).toList();
                Optional<Pair> first = pairs.stream().filter(pair -> ((DataResult)pair.getFirst()).error().isPresent()).findFirst();
                return first.map(dataResultTPair -> DataResult.error((String)((DataResult.PartialResult)((DataResult)dataResultTPair.getFirst()).error().get()).message())).orElseGet(() -> DataResult.success(consumer -> pairs.stream().sorted(Comparator.comparingInt(value -> (Integer)((DataResult)value.getFirst()).result().get())).map(Pair::getSecond).forEach((Consumer<Object>)consumer)));
            });
        }
        if ((listDecode = list.setLifecycle(Lifecycle.stable()).flatMap(stream -> {
            ImmutableList.Builder read = ImmutableList.builder();
            Stream.Builder failed = Stream.builder();
            AtomicReference<DataResult> result = new AtomicReference<DataResult>(DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable()));
            stream.accept(t -> {
                DataResult element = this.elementCodec.decode(ops, t);
                element.error().ifPresent(e -> failed.add(t));
                result.setPlain(((DataResult)result.getPlain()).apply2stable((r, v) -> {
                    read.add(v.getFirst());
                    return r;
                }, element));
            });
            ImmutableList elements = read.build();
            Object errors = ops.createList(failed.build());
            Pair pair = Pair.of((Object)elements, (Object)errors);
            return result.getPlain().map(unit -> pair).setPartial((Object)pair);
        })).error().isEmpty()) {
            return listDecode;
        }
        DataResult decode = this.elementCodec.decode(ops, input).map(pair -> pair.mapFirst(ImmutableList::of));
        if (decode.error().isEmpty()) {
            return decode;
        }
        return list.error().isPresent() ? decode : listDecode;
    }

    public String toString() {
        return "UnitList[" + this.elementCodec.toString() + "]";
    }
}

