/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.calio.api.network;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

public interface IContextAwareCodec<A>
extends Codec<A> {
    public JsonElement asJson(A var1);

    @Nullable
    public A fromJson(JsonElement var1);

    public void encode(A var1, FriendlyByteBuf var2);

    public A decode(FriendlyByteBuf var1);

    default public boolean useJson(DynamicOps<?> ops) {
        return CalioCodecHelper.isDataContext(ops);
    }

    default public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
        if (this.useJson(ops)) {
            JsonElement json = (JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input);
            try {
                A a = this.fromJson(json);
                if (a == null) {
                    return DataResult.error((String)"Json deserialization was null");
                }
                return DataResult.success((Object)Pair.of(a, (Object)ops.empty()));
            }
            catch (Exception e) {
                return DataResult.error((String)e.getMessage());
            }
        }
        return ops.getByteBuffer(input).flatMap(x -> {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.copiedBuffer((ByteBuffer)x));
            try {
                A decode = this.decode(buffer);
                DataResult dataResult = DataResult.success((Object)Pair.of(decode, (Object)ops.empty()));
                return dataResult;
            }
            catch (Exception e) {
                DataResult dataResult = DataResult.error((String)e.getMessage());
                return dataResult;
            }
            finally {
                buffer.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
        if (this.useJson(ops)) {
            try {
                JsonElement json = this.asJson(input);
                return DataResult.success((Object)JsonOps.INSTANCE.convertTo(ops, json));
            }
            catch (Exception e) {
                return DataResult.error((String)e.getMessage());
            }
        }
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        try {
            this.encode(input, buffer);
            ByteBuffer byteBuffer = buffer.nioBuffer();
            DataResult dataResult = DataResult.success((Object)ops.createByteList(byteBuffer));
            return dataResult;
        }
        catch (Exception e) {
            DataResult dataResult = DataResult.error((String)e.getMessage());
            return dataResult;
        }
        finally {
            buffer.release();
        }
    }
}

