/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.calio.api.network;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;

public class HolderSetCodec<A>
implements Codec<HolderSet<A>> {
    private final Supplier<Registry<A>> registryKey;
    private final Codec<Either<TagKey<A>, List<Holder<A>>>> registryAwareCodec;

    public HolderSetCodec(Supplier<Registry<A>> registryKey, Codec<Holder<A>> holder, Codec<TagKey<A>> tag) {
        this.registryKey = registryKey;
        this.registryAwareCodec = Codec.either(tag, CalioCodecHelper.listOf(holder));
    }

    public <T> DataResult<Pair<HolderSet<A>, T>> decode(DynamicOps<T> ops, T input) {
        return this.registryAwareCodec.decode(ops, input).map(x -> x.mapFirst(either -> (HolderSet)either.map(arg_0 -> this.registryKey.get().m_203561_(arg_0), HolderSet::m_205800_)));
    }

    public <T> DataResult<T> encode(HolderSet<A> input, DynamicOps<T> ops, T prefix) {
        Either either;
        if (input instanceof HolderSet.Named) {
            HolderSet.Named named = (HolderSet.Named)input;
            either = Either.left((Object)named.m_205839_());
        } else {
            either = Either.right(input.m_203614_().toList());
        }
        Either either2 = either;
        return this.registryAwareCodec.encode((Object)either2, ops, prefix);
    }
}

