/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.calio.api.network;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public record HolderCodec<A>(Codec<A> direct, Codec<ResourceLocation> reference, Supplier<Registry<A>> access) implements Codec<Holder<A>>
{
    public <T> DataResult<Pair<Holder<A>, T>> decode(DynamicOps<T> ops, T input) {
        DataResult stringValue = this.reference.decode(ops, input).map(Pair::getFirst);
        ArrayList<String> errors = new ArrayList<String>();
        if (stringValue.result().isPresent()) {
            ResourceLocation id = (ResourceLocation)stringValue.result().get();
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)this.access.get().m_123023_(), (ResourceLocation)id);
            Holder holder = this.access.get().m_203538_(key);
            return DataResult.success((Object)Pair.of((Object)holder, (Object)ops.empty()));
        }
        if (stringValue.error().isPresent()) {
            errors.add(((DataResult.PartialResult)stringValue.error().get()).message());
        }
        DataResult decode = this.direct.decode(ops, input).map(pair -> pair.mapFirst(Holder::m_205709_));
        return decode.mapError(err -> errors.stream().reduce(new StringBuilder((String)err), (sb, s) -> sb.append(", ").append((String)s), StringBuilder::append).toString());
    }

    public <T> DataResult<T> encode(Holder<A> input, DynamicOps<T> ops, T prefix) {
        ResourceLocation key = input.m_203543_().map(ResourceKey::m_135782_).orElse(null);
        if (key == null && input.m_203633_()) {
            key = this.access.get().m_7854_(input.m_203334_()).map(ResourceKey::m_135782_).orElse(null);
        }
        if (key != null) {
            return this.reference.encodeStart(ops, (Object)key);
        }
        return this.direct.encode(input.m_203334_(), ops, prefix);
    }
}

