/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.calio.api.network;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.calio.FilterableWeightedList;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.calio.api.CalioAPI;
import io.github.edwinmindcraft.calio.api.network.CodecSet;
import io.github.edwinmindcraft.calio.api.network.HolderCodec;
import io.github.edwinmindcraft.calio.api.network.HolderSetCodec;
import io.github.edwinmindcraft.calio.api.network.IContextAwareCodec;
import io.github.edwinmindcraft.calio.api.network.PropagatingDefaultedOptionalFieldCodec;
import io.github.edwinmindcraft.calio.api.network.PropagatingOptionalFieldCodec;
import io.github.edwinmindcraft.calio.api.network.UnitListCodec;
import io.github.edwinmindcraft.calio.api.network.primitives.BooleanCodec;
import io.github.edwinmindcraft.calio.api.network.primitives.DoubleCodec;
import io.github.edwinmindcraft.calio.api.network.primitives.FloatCodec;
import io.github.edwinmindcraft.calio.api.network.primitives.IntegerCodec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.WritableRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public class CalioCodecHelper {
    public static final Codec<Boolean> BOOL = new BooleanCodec();
    public static final Codec<Integer> INT = new IntegerCodec();
    public static final Codec<Double> DOUBLE = new DoubleCodec();
    public static final Codec<Float> FLOAT = new FloatCodec();
    public static final Codec<Component> COMPONENT_CODEC = new IContextAwareCodec<Component>(){

        @Override
        public JsonElement asJson(Component input) {
            return Component.Serializer.m_130716_((Component)input);
        }

        @Override
        @Nullable
        public Component fromJson(JsonElement input) {
            return Component.Serializer.m_130691_((JsonElement)input);
        }

        @Override
        public void encode(Component input, FriendlyByteBuf buf) {
            buf.m_130083_(input);
        }

        @Override
        public Component decode(FriendlyByteBuf buf) {
            return buf.m_130238_();
        }
    };
    public static final MapCodec<Vec3> VEC3D = CalioCodecHelper.vec3d("x", "y", "z");
    public static final MapCodec<Vector3f> VEC3F = CalioCodecHelper.vec3f("x", "y", "z");
    public static final MapCodec<BlockPos> BLOCK_POS = CalioCodecHelper.blockPos("x", "y", "z");

    public static <T> Codec<ResourceKey<T>> resourceKey(ResourceKey<? extends Registry<T>> registry) {
        Validate.notNull(registry, (String)"Registry key cannot be null", (Object[])new Object[0]);
        return SerializableDataTypes.IDENTIFIER.xmap(x -> ResourceKey.m_135785_((ResourceKey)registry, (ResourceLocation)x), ResourceKey::m_135782_);
    }

    public static <T> Codec<FilterableWeightedList<T>> weightedListOf(Codec<T> codec) {
        Validate.notNull(codec, (String)"Codec cannot be null", (Object[])new Object[0]);
        return RecordCodecBuilder.create(instance -> instance.group((App)codec.fieldOf("element").forGetter(Pair::getFirst), (App)INT.fieldOf("weight").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of)).listOf().xmap(pairs -> {
            FilterableWeightedList list = new FilterableWeightedList();
            pairs.forEach(pair -> list.m_147929_(pair.getFirst(), (Integer)pair.getSecond()));
            return list;
        }, list -> list.entryStream().map(x -> Pair.of((Object)x.m_147940_(), (Object)x.m_147945_())).toList());
    }

    public static <T> Codec<List<T>> listOf(Codec<T> codec) {
        Validate.notNull(codec, (String)"Codec cannot be null", (Object[])new Object[0]);
        return new UnitListCodec<T>(codec);
    }

    public static <T> Codec<List<T>> optionalListOf(Codec<Optional<T>> codec) {
        Validate.notNull(codec, (String)"Codec cannot be null", (Object[])new Object[0]);
        return CalioCodecHelper.listOf(codec).xmap(x -> x.stream().flatMap(Optional::stream).collect(Collectors.toList()), objects -> objects.stream().filter(Objects::nonNull).map(Optional::of).collect(Collectors.toList()));
    }

    public static <T> MapCodec<List<T>> listOf(Codec<T> codec, String singular, String plural) {
        Validate.notNull(codec, (String)"Codec cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)singular, (String)"Singular cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)plural, (String)"Plural cannot be null", (Object[])new Object[0]);
        Codec listCodec = CalioCodecHelper.listOf(codec);
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)CalioCodecHelper.optionalField(listCodec, singular, ImmutableList.of()).forGetter(x -> x.size() == 1 ? x : ImmutableList.of()), (App)CalioCodecHelper.optionalField(listCodec, plural, ImmutableList.of()).forGetter(x -> x.size() == 1 ? ImmutableList.of() : x)).apply((Applicative)instance, (ls1, ls2) -> ImmutableList.builder().addAll((Iterable)ls1).addAll((Iterable)ls2).build()));
    }

    public static <T> Codec<Set<T>> setOf(Codec<T> codec) {
        Validate.notNull(codec, (String)"Codec cannot be null", (Object[])new Object[0]);
        return CalioCodecHelper.listOf(codec).xmap(HashSet::new, ArrayList::new);
    }

    public static <T> Codec<Holder<T>> holder(Supplier<Registry<T>> access, Codec<ResourceLocation> reference, Codec<T> direct) {
        return new HolderCodec<T>(direct, reference, access);
    }

    public static <T> Codec<HolderSet<T>> holderSet(Supplier<Registry<T>> access, Codec<TagKey<T>> tag, Codec<Holder<T>> holder) {
        return new HolderSetCodec(access, holder, tag);
    }

    public static <T> CodecSet<T> codecSet(Supplier<Registry<T>> access, ResourceKey<Registry<T>> key, Codec<ResourceLocation> reference, Codec<T> direct) {
        Codec<Holder<T>> holder = CalioCodecHelper.holder(access, reference, direct);
        Codec holderRef = reference.flatComapMap(id -> ((Registry)access.get()).m_203538_(ResourceKey.m_135785_((ResourceKey)key, (ResourceLocation)id)), h -> (DataResult)h.m_203439_().map(x -> DataResult.success((Object)x.m_135782_()), arg_0 -> CalioCodecHelper.lambda$codecSet$15((Supplier)access, arg_0)));
        Codec directTag = reference.xmap(location -> TagKey.m_203882_((ResourceKey)key, (ResourceLocation)location), TagKey::f_203868_);
        Codec hashedTag = Codec.STRING.comapFlatMap(string -> string.startsWith("#") ? ResourceLocation.m_135837_((String)string.substring(1)).map(loc -> TagKey.m_203882_((ResourceKey)key, (ResourceLocation)loc)) : DataResult.error((String)"Not a tag id"), tag -> "#" + tag.f_203868_());
        Codec<HolderSet<T>> directSet = CalioCodecHelper.holderSet(access, directTag, holder);
        Codec<HolderSet<T>> hashedSet = CalioCodecHelper.holderSet(access, hashedTag, holder);
        Codec<List<HolderSet<T>>> set = CalioCodecHelper.listOf(hashedSet);
        return new CodecSet<T>(holder, holderRef, directTag, hashedTag, directSet, hashedSet, set);
    }

    public static <T> CodecSet<T> forDynamicRegistry(ResourceKey<Registry<T>> key, Codec<ResourceLocation> reference, Codec<T> direct) {
        Supplier<Registry<T>> supplier = () -> CalioAPI.getDynamicRegistries().get(key);
        return CalioCodecHelper.codecSet(supplier, key, reference, direct);
    }

    public static <A> PropagatingOptionalFieldCodec<A> optionalField(Codec<A> codec, String name) {
        Validate.notNull(codec, (String)"Codec cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)name, (String)"Name cannot be null", (Object[])new Object[0]);
        return new PropagatingOptionalFieldCodec<A>(name, codec);
    }

    public static <A> PropagatingDefaultedOptionalFieldCodec<A> optionalField(Codec<A> codec, String name, A defaultValue) {
        Validate.notNull(codec, (String)"Codec cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)name, (String)"Name cannot be null", (Object[])new Object[0]);
        Validate.notNull(defaultValue, (String)"Default value cannot be null", (Object[])new Object[0]);
        return new PropagatingDefaultedOptionalFieldCodec<Object>(name, codec, () -> defaultValue);
    }

    public static <A> PropagatingDefaultedOptionalFieldCodec<A> optionalField(Codec<A> codec, String name, Supplier<A> defaultValue) {
        Validate.notNull(codec, (String)"Codec cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)name, (String)"Name cannot be null", (Object[])new Object[0]);
        Validate.notNull(defaultValue, (String)"Default value cannot be null", (Object[])new Object[0]);
        return new PropagatingDefaultedOptionalFieldCodec<A>(name, codec, defaultValue);
    }

    public static <A extends IForgeRegistryEntry<A>> PropagatingDefaultedOptionalFieldCodec<Holder<A>> registryDefaultedField(Codec<Holder<A>> codec, String name, ResourceKey<Registry<A>> registry, Supplier<IForgeRegistry<A>> builtin) {
        Supplier<Holder> supplier = () -> {
            Holder holder;
            WritableRegistry patt9276$temp = CalioAPI.getDynamicRegistries().get(registry);
            if (patt9276$temp instanceof DefaultedRegistry) {
                DefaultedRegistry def = (DefaultedRegistry)patt9276$temp;
                holder = def.m_206081_(ResourceKey.m_135785_((ResourceKey)registry, (ResourceLocation)def.m_122315_()));
            } else {
                holder = (Holder)((IForgeRegistry)builtin.get()).getHolder(((IForgeRegistry)builtin.get()).getDefaultKey()).orElseThrow();
            }
            return holder;
        };
        return CalioCodecHelper.optionalField(codec, name, supplier);
    }

    public static <A extends IForgeRegistryEntry<A>> PropagatingDefaultedOptionalFieldCodec<Holder<A>> registryField(Codec<Holder<A>> codec, String name, ResourceKey<A> value, ResourceKey<Registry<A>> registry, Supplier<IForgeRegistry<A>> builtin) {
        Supplier<Holder> supplier = () -> {
            Holder holder;
            WritableRegistry patt9841$temp = CalioAPI.getDynamicRegistries().get(registry);
            if (patt9841$temp instanceof DefaultedRegistry) {
                DefaultedRegistry def = (DefaultedRegistry)patt9841$temp;
                holder = def.m_206081_(value);
            } else {
                holder = (Holder)((IForgeRegistry)builtin.get()).getHolder(value).orElseThrow();
            }
            return holder;
        };
        return CalioCodecHelper.optionalField(codec, name, supplier);
    }

    public static MapCodec<Vec3> vec3d(String xName, String yName, String zName) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)CalioCodecHelper.optionalField(DOUBLE, xName, 0.0).forGetter(Vec3::m_7096_), (App)CalioCodecHelper.optionalField(DOUBLE, yName, 0.0).forGetter(Vec3::m_7098_), (App)CalioCodecHelper.optionalField(DOUBLE, zName, 0.0).forGetter(Vec3::m_7094_)).apply((Applicative)instance, Vec3::new));
    }

    public static MapCodec<Vector3f> vec3f(String xName, String yName, String zName) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)CalioCodecHelper.optionalField(FLOAT, xName, Float.valueOf(0.0f)).forGetter(Vector3f::m_122239_), (App)CalioCodecHelper.optionalField(FLOAT, yName, Float.valueOf(0.0f)).forGetter(Vector3f::m_122260_), (App)CalioCodecHelper.optionalField(FLOAT, zName, Float.valueOf(0.0f)).forGetter(Vector3f::m_122269_)).apply((Applicative)instance, Vector3f::new));
    }

    public static MapCodec<Vec3> vec3d(String prefix) {
        return CalioCodecHelper.vec3d(prefix + "x", prefix + "y", prefix + "z");
    }

    public static MapCodec<BlockPos> blockPos(String xName, String yName, String zName) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)CalioCodecHelper.optionalField(INT, xName, 0).forGetter(Vec3i::m_123341_), (App)CalioCodecHelper.optionalField(INT, yName, 0).forGetter(Vec3i::m_123342_), (App)CalioCodecHelper.optionalField(INT, zName, 0).forGetter(Vec3i::m_123343_)).apply((Applicative)instance, BlockPos::new));
    }

    public static MapCodec<BlockPos> blockPos(String prefix) {
        return CalioCodecHelper.blockPos(prefix + "x", prefix + "y", prefix + "z");
    }

    public static <T> CodecJsonAdapter<T> jsonAdapter(Codec<T> input) {
        return new CodecJsonAdapter<T>(input);
    }

    public static boolean isDataContext(DynamicOps<?> ops) {
        return ops instanceof JsonOps && !ops.compressMaps();
    }

    private static /* synthetic */ DataResult lambda$codecSet$15(Supplier access, Object t) {
        return ((Registry)access.get()).m_7854_(t).map(ResourceKey::m_135782_).map(DataResult::success).orElseGet(() -> DataResult.error((String)"Key not in registry."));
    }

    public static class CodecJsonAdapter<T>
    implements JsonSerializer<T>,
    JsonDeserializer<T> {
        private final Codec<T> codec;

        private CodecJsonAdapter(Codec<T> codec) {
            this.codec = codec;
        }

        public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return (T)((Pair)this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, s -> {
                throw new JsonParseException("Found error: " + s);
            })).getFirst();
        }

        public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
            return (JsonElement)this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, src).getOrThrow(false, s -> {});
        }
    }
}

