/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.fabric;

import com.mojang.serialization.Codec;
import io.github.apace100.apoli.power.Power;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.fabric.FabricPowerConfiguration;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class FabricPowerFactory<P extends Power>
extends PowerFactory<FabricPowerConfiguration<P>> {
    public FabricPowerFactory(Codec<FabricPowerConfiguration<P>> codec, boolean allowConditions) {
        super(codec, allowConditions);
    }

    private P getPower(ConfiguredPower<FabricPowerConfiguration<P>, ?> configuration, LivingEntity entity) {
        return (P)((Power)configuration.getPowerData((Entity)entity, () -> (Power)((FabricPowerConfiguration)configuration.getConfiguration()).power().apply(configuration.getPowerType(), entity)));
    }

    private P getPower(ConfiguredPower<FabricPowerConfiguration<P>, ?> configuration, LivingEntity entity, IPowerContainer container) {
        return (P)((Power)configuration.getPowerData(container, () -> (Power)((FabricPowerConfiguration)configuration.getConfiguration()).power().apply(configuration.getPowerType(), entity)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isActive(ConfiguredPower<FabricPowerConfiguration<P>, ?> configuration, Entity entity) {
        if (!(entity instanceof LivingEntity)) return false;
        LivingEntity living = (LivingEntity)entity;
        if (!super.isActive(configuration, entity)) return false;
        if (!((Power)this.getPower(configuration, living)).isActive()) return false;
        return true;
    }

    @Override
    protected boolean shouldTickWhenActive(ConfiguredPower<FabricPowerConfiguration<P>, ?> configuration, Entity entity) {
        LivingEntity living;
        return entity instanceof LivingEntity && ((Power)this.getPower(configuration, living = (LivingEntity)entity)).shouldTick();
    }

    @Override
    protected boolean shouldTickWhenInactive(ConfiguredPower<FabricPowerConfiguration<P>, ?> configuration, Entity entity) {
        LivingEntity living;
        return entity instanceof LivingEntity && ((Power)this.getPower(configuration, living = (LivingEntity)entity)).shouldTickWhenInactive();
    }

    @Override
    public void tick(ConfiguredPower<FabricPowerConfiguration<P>, ?> configuration, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ((Power)this.getPower(configuration, living)).tick();
        }
    }

    @Override
    public void onGained(ConfiguredPower<FabricPowerConfiguration<P>, ?> configuration, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ((Power)this.getPower(configuration, living)).onGained();
        }
    }

    @Override
    public void onLost(ConfiguredPower<FabricPowerConfiguration<P>, ?> configuration, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ((Power)this.getPower(configuration, living)).onLost();
        }
    }

    @Override
    public void onAdded(ConfiguredPower<FabricPowerConfiguration<P>, ?> configuration, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ((Power)this.getPower(configuration, living)).onAdded();
        }
    }

    @Override
    public void onRemoved(ConfiguredPower<FabricPowerConfiguration<P>, ?> configuration, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ((Power)this.getPower(configuration, living)).onRemoved();
        }
    }

    @Override
    public void onRespawn(ConfiguredPower<FabricPowerConfiguration<P>, ?> configuration, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ((Power)this.getPower(configuration, living)).onRespawn();
        }
    }

    @Override
    public void serialize(ConfiguredPower<FabricPowerConfiguration<P>, ?> configuration, IPowerContainer container, CompoundTag tag) {
        Entity entity = container.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            tag.m_128365_("FabricData", ((Power)this.getPower(configuration, living, container)).toTag());
        }
    }

    @Override
    public void deserialize(ConfiguredPower<FabricPowerConfiguration<P>, ?> configuration, IPowerContainer container, CompoundTag tag) {
        Entity entity = container.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ((Power)this.getPower(configuration, living, container)).fromTag((Tag)tag);
        }
    }
}

