/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.registry.condition;

import io.github.apace100.apoli.Apoli;
import io.github.edwinmindcraft.apoli.api.MetaFactories;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredFluidCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.FluidCondition;
import io.github.edwinmindcraft.apoli.api.registry.ApoliRegistries;
import io.github.edwinmindcraft.apoli.common.condition.fluid.DelegatedFluidCondition;
import io.github.edwinmindcraft.apoli.common.condition.fluid.FluidMatchesCondition;
import io.github.edwinmindcraft.apoli.common.condition.fluid.InTagFluidCondition;
import io.github.edwinmindcraft.apoli.common.condition.fluid.SimpleFluidCondition;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConditionStreamConfiguration;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConstantConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliRegisters;
import java.util.Arrays;
import java.util.function.BiPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.RegistryObject;

public class ApoliFluidConditions {
    public static final BiPredicate<ConfiguredFluidCondition<?, ?>, FluidState> PREDICATE = (config, biome) -> config.check((FluidState)biome);
    public static final RegistryObject<DelegatedFluidCondition<ConstantConfiguration<FluidState>>> CONSTANT = ApoliFluidConditions.of("constant");
    public static final RegistryObject<DelegatedFluidCondition<ConditionStreamConfiguration<ConfiguredFluidCondition<?, ?>, FluidState>>> AND = ApoliFluidConditions.of("and");
    public static final RegistryObject<DelegatedFluidCondition<ConditionStreamConfiguration<ConfiguredFluidCondition<?, ?>, FluidState>>> OR = ApoliFluidConditions.of("or");
    public static final RegistryObject<SimpleFluidCondition> EMPTY = ApoliRegisters.FLUID_CONDITIONS.register("empty", () -> new SimpleFluidCondition(FluidState::m_76178_));
    public static final RegistryObject<SimpleFluidCondition> STILL = ApoliRegisters.FLUID_CONDITIONS.register("still", () -> new SimpleFluidCondition(FluidState::m_76170_));
    public static final RegistryObject<InTagFluidCondition> IN_TAG = ApoliRegisters.FLUID_CONDITIONS.register("in_tag", InTagFluidCondition::new);
    public static final RegistryObject<FluidMatchesCondition> FLUID = ApoliRegisters.FLUID_CONDITIONS.register("fluid", FluidMatchesCondition::new);

    private static <U extends FluidCondition<?>> RegistryObject<U> of(String name) {
        return RegistryObject.create((ResourceLocation)Apoli.identifier(name), (ResourceLocation)ApoliRegistries.FLUID_CONDITION_KEY.m_135782_(), (String)"apoli");
    }

    public static ConfiguredFluidCondition<?, ?> constant(boolean value) {
        return (ConfiguredFluidCondition)((DelegatedFluidCondition)CONSTANT.get()).configure(new ConstantConfiguration(value));
    }

    @SafeVarargs
    public static ConfiguredFluidCondition<?, ?> and(HolderSet<ConfiguredFluidCondition<?, ?>> ... conditions) {
        return (ConfiguredFluidCondition)((DelegatedFluidCondition)AND.get()).configure(ConditionStreamConfiguration.and(Arrays.asList(conditions), PREDICATE));
    }

    @SafeVarargs
    public static ConfiguredFluidCondition<?, ?> or(HolderSet<ConfiguredFluidCondition<?, ?>> ... conditions) {
        return (ConfiguredFluidCondition)((DelegatedFluidCondition)OR.get()).configure(ConditionStreamConfiguration.or(Arrays.asList(conditions), PREDICATE));
    }

    public static void bootstrap() {
        MetaFactories.defineMetaConditions(ApoliRegisters.FLUID_CONDITIONS, DelegatedFluidCondition::new, ConfiguredFluidCondition.CODEC_SET, PREDICATE);
    }
}

