/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.registry.condition;

import com.mojang.serialization.MapCodec;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.access.MovingEntity;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.mixin.EntityAccessor;
import io.github.apace100.apoli.power.factory.condition.DistanceFromCoordinatesConditionRegistry;
import io.github.apace100.apoli.power.factory.condition.entity.ElytraFlightPossibleCondition;
import io.github.apace100.apoli.power.factory.condition.entity.RaycastCondition;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.MetaFactories;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.EntityCondition;
import io.github.edwinmindcraft.apoli.api.registry.ApoliRegistries;
import io.github.edwinmindcraft.apoli.common.condition.entity.AdvancementCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.AttributeCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.BiEntityWrappedCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.BiomeCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.BlockCollisionCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.BlockInRadiusCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.CommandCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.DelegatedEntityCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.EnchantmentCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.EquippedItemCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.FloatComparingEntityCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.FluidHeightCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.GameModeCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.HolderBasedEntityCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.InBlockAnywhereCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.InTagCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.IntComparingBECEntityCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.IntComparingEntityCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.OnBlockCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.PowerActiveCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.PowerCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.ResourceCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.ScoreboardCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.SimpleEntityCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.SingleFieldEntityCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.StatusEffectCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.SubmergedInCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.UsingEffectiveToolCondition;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConditionStreamConfiguration;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConstantConfiguration;
import io.github.edwinmindcraft.apoli.common.power.ClimbingPower;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import io.github.edwinmindcraft.apoli.common.registry.ApoliRegisters;
import io.github.edwinmindcraft.calio.api.ability.IAbilityHolder;
import io.github.edwinmindcraft.calio.api.ability.PlayerAbility;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.RegistryObject;

public class ApoliEntityConditions {
    public static final BiPredicate<ConfiguredEntityCondition<?, ?>, Entity> PREDICATE = ConfiguredEntityCondition::check;
    public static final RegistryObject<DelegatedEntityCondition<ConstantConfiguration<Entity>>> CONSTANT = ApoliEntityConditions.of("constant");
    public static final RegistryObject<DelegatedEntityCondition<ConditionStreamConfiguration<ConfiguredEntityCondition<?, ?>, Entity>>> AND = ApoliEntityConditions.of("and");
    public static final RegistryObject<DelegatedEntityCondition<ConditionStreamConfiguration<ConfiguredEntityCondition<?, ?>, Entity>>> OR = ApoliEntityConditions.of("or");
    public static final RegistryObject<SimpleEntityCondition> DAYTIME = ApoliEntityConditions.register("daytime", (Entity entity) -> entity.f_19853_.m_46468_() % 24000L < 13000L);
    public static final RegistryObject<SimpleEntityCondition> FALL_FLYING = ApoliEntityConditions.registerLiving("fall_flying", LivingEntity::m_21255_);
    public static final RegistryObject<SimpleEntityCondition> EXPOSED_TO_SUN = ApoliEntityConditions.register("exposed_to_sun", SimpleEntityCondition::isExposedToSun);
    public static final RegistryObject<SimpleEntityCondition> IN_RAIN = ApoliEntityConditions.register("in_rain", (Entity x) -> ((EntityAccessor)x).callIsBeingRainedOn());
    public static final RegistryObject<SimpleEntityCondition> INVISIBLE = ApoliEntityConditions.register("invisible", Entity::m_20145_);
    public static final RegistryObject<SimpleEntityCondition> ON_FIRE = ApoliEntityConditions.register("on_fire", Entity::m_6060_);
    public static final RegistryObject<SimpleEntityCondition> EXPOSED_TO_SKY = ApoliEntityConditions.register("exposed_to_sky", SimpleEntityCondition::isExposedToSky);
    public static final RegistryObject<SimpleEntityCondition> SNEAKING = ApoliEntityConditions.register("sneaking", Entity::m_6144_);
    public static final RegistryObject<SimpleEntityCondition> SPRINTING = ApoliEntityConditions.register("sprinting", Entity::m_20142_);
    public static final RegistryObject<SimpleEntityCondition> SWIMMING = ApoliEntityConditions.register("swimming", Entity::m_6069_);
    public static final RegistryObject<SimpleEntityCondition> COLLIDED_HORIZONTALLY = ApoliEntityConditions.register("collided_horizontally", (Entity t) -> t.f_19862_);
    public static final RegistryObject<SimpleEntityCondition> CLIMBING = ApoliEntityConditions.registerLiving("climbing", living -> living.m_6147_() || IPowerContainer.hasPower((Entity)living, (ClimbingPower)((Object)((Object)ApoliPowers.CLIMBING.get()))));
    public static final RegistryObject<SimpleEntityCondition> TAMED = ApoliEntityConditions.register("tamed", (Entity x) -> {
        TamableAnimal te;
        return x instanceof TamableAnimal && (te = (TamableAnimal)x).m_21824_();
    });
    public static final RegistryObject<SimpleEntityCondition> MOVING = ApoliEntityConditions.register("moving", (Entity x) -> ((MovingEntity)x).isMoving());
    public static final RegistryObject<FloatComparingEntityCondition> BRIGHTNESS = ApoliEntityConditions.registerFloat("brightness", Entity::m_6073_);
    public static final RegistryObject<FloatComparingEntityCondition> SATURATION_LEVEL = ApoliEntityConditions.registerFloat("saturation_level", x -> x instanceof Player ? Float.valueOf(((Player)x).m_36324_().m_38722_()) : null);
    public static final RegistryObject<FloatComparingEntityCondition> HEALTH = ApoliEntityConditions.registerFloatLiving("health", LivingEntity::m_21223_);
    public static final RegistryObject<FloatComparingEntityCondition> RELATIVE_HEALTH = ApoliEntityConditions.registerFloatLiving("relative_health", t -> Float.valueOf(t.m_21223_() / t.m_21233_()));
    public static final RegistryObject<FloatComparingEntityCondition> FALL_DISTANCE = ApoliEntityConditions.registerFloat("fall_distance", t -> Float.valueOf(t.f_19789_));
    public static final RegistryObject<IntComparingEntityCondition> TIME_OF_DAY = ApoliEntityConditions.registerInt("time_of_day", t -> Math.toIntExact(t.f_19853_.m_46468_() % 24000L));
    public static final RegistryObject<IntComparingEntityCondition> AIR = ApoliEntityConditions.registerInt("air", Entity::m_20146_);
    public static final RegistryObject<IntComparingEntityCondition> FOOD_LEVEL = ApoliEntityConditions.registerIntPlayer("food_level", x -> x.m_36324_().m_38702_());
    public static final RegistryObject<IntComparingEntityCondition> XP_LEVELS = ApoliEntityConditions.registerIntPlayer("xp_levels", x -> x.f_36078_);
    public static final RegistryObject<IntComparingEntityCondition> XP_POINTS = ApoliEntityConditions.registerIntPlayer("xp_points", x -> x.f_36079_);
    public static final RegistryObject<EnchantmentCondition> ENCHANTMENT = ApoliEntityConditions.register("enchantment", EnchantmentCondition::new);
    public static final RegistryObject<BlockCollisionCondition> BLOCK_COLLISION = ApoliEntityConditions.register("block_collision", BlockCollisionCondition::new);
    public static final RegistryObject<PowerActiveCondition> POWER_ACTIVE = ApoliEntityConditions.register("power_active", PowerActiveCondition::new);
    public static final RegistryObject<StatusEffectCondition> STATUS_EFFECT = ApoliEntityConditions.register("status_effect", StatusEffectCondition::new);
    public static final RegistryObject<SubmergedInCondition> SUBMERGED_IN = ApoliEntityConditions.register("submerged_in", SubmergedInCondition::new);
    public static final RegistryObject<SingleFieldEntityCondition<EntityType<?>>> ENTITY_TYPE = ApoliEntityConditions.register("entity_type", SerializableDataTypes.ENTITY_TYPE.fieldOf("entity_type"), (entity, o) -> Objects.equals(o, entity.m_6095_()));
    public static final RegistryObject<InTagCondition> IN_TAG = ApoliEntityConditions.register("in_tag", InTagCondition::new);
    public static final RegistryObject<PowerCondition> POWER = ApoliEntityConditions.register("power", PowerCondition::new);
    public static final RegistryObject<FluidHeightCondition> FLUID_HEIGHT = ApoliEntityConditions.register("fluid_height", FluidHeightCondition::new);
    public static final RegistryObject<OnBlockCondition> ON_BLOCK = ApoliEntityConditions.register("on_block", OnBlockCondition::new);
    public static final RegistryObject<HolderBasedEntityCondition<ConfiguredBlockCondition<?, ?>>> IN_BLOCK = ApoliEntityConditions.register("in_block", () -> HolderBasedEntityCondition.required(ConfiguredBlockCondition.required("block_condition"), (entity, configuration) -> ConfiguredBlockCondition.check(configuration, (LevelReader)entity.f_19853_, entity.m_142538_())));
    public static final RegistryObject<ResourceCondition> RESOURCE = ApoliEntityConditions.register("resource", ResourceCondition::new);
    public static final RegistryObject<SingleFieldEntityCondition<ResourceKey<Level>>> DIMENSION = ApoliEntityConditions.register("dimension", SerializableDataTypes.DIMENSION.fieldOf("dimension"), (entity, dimension) -> entity.m_20193_().m_46472_().equals(dimension));
    public static final RegistryObject<SingleFieldEntityCondition<MobType>> ENTITY_GROUP = ApoliEntityConditions.register("entity_group", SerializableDataTypes.ENTITY_GROUP.fieldOf("group"), (entity, group) -> {
        LivingEntity living;
        return entity instanceof LivingEntity && (living = (LivingEntity)entity).m_6336_().equals(group);
    });
    public static final RegistryObject<HolderBasedEntityCondition<ConfiguredItemCondition<?, ?>>> USING_ITEM = ApoliEntityConditions.register("using_item", () -> HolderBasedEntityCondition.optional(ConfiguredItemCondition.optional("item_condition"), (entity, configuration) -> {
        LivingEntity living;
        return entity instanceof LivingEntity && (living = (LivingEntity)entity).m_6117_() && ConfiguredItemCondition.check(configuration, living.f_19853_, living.m_21120_(living.m_7655_()));
    }));
    public static final RegistryObject<SingleFieldEntityCondition<ResourceLocation>> PREDICATE_CONDITION = ApoliEntityConditions.register("predicate", ResourceLocation.f_135803_.fieldOf("predicate"), SingleFieldEntityCondition::checkPredicate);
    public static final RegistryObject<EquippedItemCondition> EQUIPPED_ITEM = ApoliEntityConditions.register("equipped_item", EquippedItemCondition::new);
    public static final RegistryObject<CommandCondition> COMMAND = ApoliEntityConditions.register("command", CommandCondition::new);
    public static final RegistryObject<AttributeCondition> ATTRIBUTE = ApoliEntityConditions.register("attribute", AttributeCondition::new);
    public static final RegistryObject<BlockInRadiusCondition> BLOCK_IN_RADIUS = ApoliEntityConditions.register("block_in_radius", BlockInRadiusCondition::new);
    public static final RegistryObject<BiomeCondition> BIOME = ApoliEntityConditions.register("biome", BiomeCondition::new);
    public static final RegistryObject<ScoreboardCondition> SCOREBOARD = ApoliEntityConditions.register("scoreboard", ScoreboardCondition::new);
    public static final RegistryObject<InBlockAnywhereCondition> IN_BLOCK_ANYWHERE = ApoliEntityConditions.register("in_block_anywhere", InBlockAnywhereCondition::new);
    public static final RegistryObject<UsingEffectiveToolCondition> USING_EFFECTIVE_TOOL = ApoliEntityConditions.registerSided("using_effective_tool", () -> UsingEffectiveToolCondition.Client::new, () -> UsingEffectiveToolCondition::new);
    public static final RegistryObject<AdvancementCondition> ADVANCEMENT = ApoliEntityConditions.registerSided("advancement", () -> AdvancementCondition.Client::new, () -> AdvancementCondition::new);
    public static final RegistryObject<GameModeCondition> GAMEMODE = ApoliEntityConditions.registerSided("gamemode", () -> GameModeCondition.Client::new, () -> GameModeCondition::new);
    public static final RegistryObject<RaycastCondition> RAYCAST = ApoliEntityConditions.register("raycast", RaycastCondition::new);
    public static final RegistryObject<ElytraFlightPossibleCondition> ELYTRA_FLIGHT_POSSIBLE = ApoliEntityConditions.register("elytra_flight_possible", ElytraFlightPossibleCondition::new);
    public static final RegistryObject<BiEntityWrappedCondition> RIDING = ApoliEntityConditions.register("riding", () -> new BiEntityWrappedCondition(BiEntityWrappedCondition::riding));
    public static final RegistryObject<BiEntityWrappedCondition> RIDING_ROOT = ApoliEntityConditions.register("riding_root", () -> new BiEntityWrappedCondition(BiEntityWrappedCondition::ridingRoot));
    public static final RegistryObject<IntComparingBECEntityCondition> RIDING_RECURSIVE = ApoliEntityConditions.register("riding_recursive", () -> new IntComparingBECEntityCondition(IntComparingBECEntityCondition::ridingRecursive));
    public static final RegistryObject<SimpleEntityCondition> LIVING = ApoliEntityConditions.register("living", (Entity e) -> e instanceof LivingEntity);
    public static final RegistryObject<IntComparingBECEntityCondition> PASSENGER = ApoliEntityConditions.register("passenger", () -> new IntComparingBECEntityCondition(IntComparingBECEntityCondition::passenger));
    public static final RegistryObject<IntComparingBECEntityCondition> PASSENGER_RECURSIVE = ApoliEntityConditions.register("passenger_recursive", () -> new IntComparingBECEntityCondition(IntComparingBECEntityCondition::passengerRecursive));
    public static final RegistryObject<SingleFieldEntityCondition<CompoundTag>> NBT = ApoliEntityConditions.register("nbt", SerializableDataTypes.NBT.fieldOf("nbt"), SingleFieldEntityCondition::nbt);
    public static final RegistryObject<SimpleEntityCondition> EXISTS = ApoliEntityConditions.register("exists", Objects::nonNull);
    public static final RegistryObject<SimpleEntityCondition> CREATIVE_FLYING = ApoliEntityConditions.registerPlayer("creative_flying", x -> x.m_150110_().f_35935_);
    public static final RegistryObject<SingleFieldEntityCondition<ResourceLocation>> POWER_TYPE = ApoliEntityConditions.register("power_type", SerializableDataTypes.IDENTIFIER.fieldOf("power_type"), (entity, rl) -> IPowerContainer.get(entity).map(container -> container.getPowerTypes(true).contains(rl)).orElse(false));
    public static final RegistryObject<SingleFieldEntityCondition<PlayerAbility>> ABILITY = ApoliEntityConditions.register("ability", ApoliDataTypes.PLAYER_ABILITY.fieldOf("player_ability"), IAbilityHolder::has);

    private static <U extends EntityCondition<?>> RegistryObject<U> of(String name) {
        return RegistryObject.create((ResourceLocation)Apoli.identifier(name), (ResourceLocation)ApoliRegistries.ENTITY_CONDITION_KEY.m_135782_(), (String)"apoli");
    }

    public static ConfiguredEntityCondition<?, ?> constant(boolean value) {
        return (ConfiguredEntityCondition)((DelegatedEntityCondition)CONSTANT.get()).configure(new ConstantConfiguration(value));
    }

    @SafeVarargs
    public static ConfiguredEntityCondition<?, ?> and(HolderSet<ConfiguredEntityCondition<?, ?>> ... conditions) {
        return (ConfiguredEntityCondition)((DelegatedEntityCondition)AND.get()).configure(ConditionStreamConfiguration.and(Arrays.asList(conditions), PREDICATE));
    }

    public static ConfiguredEntityCondition<?, ?> and(ConfiguredEntityCondition<?, ?> ... conditions) {
        return ApoliEntityConditions.and(new HolderSet[]{HolderSet.m_205806_(Holder::m_205709_, (Object[])conditions)});
    }

    @SafeVarargs
    public static ConfiguredEntityCondition<?, ?> or(HolderSet<ConfiguredEntityCondition<?, ?>> ... conditions) {
        return (ConfiguredEntityCondition)((DelegatedEntityCondition)OR.get()).configure(ConditionStreamConfiguration.or(Arrays.asList(conditions), PREDICATE));
    }

    public static ConfiguredEntityCondition<?, ?> or(ConfiguredEntityCondition<?, ?> ... conditions) {
        return ApoliEntityConditions.or(new HolderSet[]{HolderSet.m_205806_(Holder::m_205709_, (Object[])conditions)});
    }

    public static void bootstrap() {
        MetaFactories.defineMetaConditions(ApoliRegisters.ENTITY_CONDITIONS, DelegatedEntityCondition::new, ConfiguredEntityCondition.CODEC_SET, PREDICATE);
        DistanceFromCoordinatesConditionRegistry.registerEntityCondition();
    }

    private static <T extends EntityCondition<?>> RegistryObject<T> register(String name, Supplier<T> factory) {
        return ApoliRegisters.ENTITY_CONDITIONS.register(name, factory);
    }

    private static RegistryObject<SimpleEntityCondition> register(String name, Predicate<Entity> factory) {
        return ApoliEntityConditions.register(name, () -> new SimpleEntityCondition(factory));
    }

    private static RegistryObject<SimpleEntityCondition> registerLiving(String name, Predicate<LivingEntity> factory) {
        return ApoliEntityConditions.register(name, () -> new SimpleEntityCondition(x -> {
            LivingEntity living;
            return x instanceof LivingEntity && factory.test(living = (LivingEntity)x);
        }));
    }

    private static RegistryObject<SimpleEntityCondition> registerPlayer(String name, Predicate<Player> factory) {
        return ApoliEntityConditions.register(name, () -> new SimpleEntityCondition(x -> {
            Player player;
            return x instanceof Player && factory.test(player = (Player)x);
        }));
    }

    private static RegistryObject<IntComparingEntityCondition> registerInt(String name, Function<Entity, Integer> factory) {
        return ApoliEntityConditions.register(name, () -> new IntComparingEntityCondition(factory));
    }

    private static RegistryObject<IntComparingEntityCondition> registerIntPlayer(String name, Function<Player, Integer> factory) {
        return ApoliEntityConditions.registerInt(name, living -> {
            Integer n;
            if (living instanceof Player) {
                Player pe = (Player)living;
                n = (Integer)factory.apply(pe);
            } else {
                n = null;
            }
            return n;
        });
    }

    private static RegistryObject<FloatComparingEntityCondition> registerFloat(String name, Function<Entity, Float> factory) {
        return ApoliEntityConditions.register(name, () -> new FloatComparingEntityCondition(factory));
    }

    private static RegistryObject<FloatComparingEntityCondition> registerFloatLiving(String name, Function<LivingEntity, Float> factory) {
        return ApoliEntityConditions.register(name, () -> new FloatComparingEntityCondition(x -> {
            Float f;
            if (x instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)x;
                f = (Float)factory.apply(living);
            } else {
                f = null;
            }
            return f;
        }));
    }

    private static <T> RegistryObject<SingleFieldEntityCondition<T>> register(String name, MapCodec<T> codec, BiPredicate<Entity, T> predicate) {
        return ApoliEntityConditions.register(name, () -> new SingleFieldEntityCondition(codec, predicate));
    }

    private static <T extends EntityCondition<?>> RegistryObject<T> registerSided(String name, Supplier<Supplier<T>> client, Supplier<Supplier<T>> server) {
        return ApoliEntityConditions.register(name, () -> (EntityCondition)DistExecutor.unsafeRunForDist((Supplier)client, (Supplier)server));
    }
}

