/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.registry.condition;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.edwinmindcraft.apoli.api.MetaFactories;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBiomeCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.BiomeCondition;
import io.github.edwinmindcraft.apoli.api.registry.ApoliRegistries;
import io.github.edwinmindcraft.apoli.common.condition.biome.DelegatedBiomeCondition;
import io.github.edwinmindcraft.apoli.common.condition.biome.FloatComparingBiomeCondition;
import io.github.edwinmindcraft.apoli.common.condition.biome.HighHumidityCondition;
import io.github.edwinmindcraft.apoli.common.condition.biome.PropertyBiomeCondition;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConditionStreamConfiguration;
import io.github.edwinmindcraft.apoli.common.condition.meta.ConstantConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliRegisters;
import java.util.Arrays;
import java.util.function.BiPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.RegistryObject;

public class ApoliBiomeConditions {
    public static final BiPredicate<ConfiguredBiomeCondition<?, ?>, Holder<Biome>> PREDICATE = ConfiguredBiomeCondition::check;
    public static final RegistryObject<DelegatedBiomeCondition<ConstantConfiguration<Holder<Biome>>>> CONSTANT = ApoliBiomeConditions.of("constant");
    public static final RegistryObject<DelegatedBiomeCondition<ConditionStreamConfiguration<ConfiguredBiomeCondition<?, ?>, Holder<Biome>>>> AND = ApoliBiomeConditions.of("and");
    public static final RegistryObject<DelegatedBiomeCondition<ConditionStreamConfiguration<ConfiguredBiomeCondition<?, ?>, Holder<Biome>>>> OR = ApoliBiomeConditions.of("or");
    public static final RegistryObject<PropertyBiomeCondition<Biome.BiomeCategory>> CATEGORY = ApoliRegisters.BIOME_CONDITIONS.register("category", () -> new PropertyBiomeCondition<Biome.BiomeCategory>("category", SerializableDataType.enumValue(Biome.BiomeCategory.class, Biome.BiomeCategory::m_47645_), Biome::m_204183_));
    public static final RegistryObject<HighHumidityCondition> HIGH_HUMIDITY = ApoliRegisters.BIOME_CONDITIONS.register("high_humidity", HighHumidityCondition::new);
    public static final RegistryObject<PropertyBiomeCondition<Biome.Precipitation>> PRECIPITATION = ApoliRegisters.BIOME_CONDITIONS.register("precipitation", () -> new PropertyBiomeCondition<Biome.Precipitation>("precipitation", SerializableDataType.enumValue(Biome.Precipitation.class, Biome.Precipitation::m_47731_), x -> x.m_203633_() ? ((Biome)x.m_203334_()).m_47530_() : null));
    public static final RegistryObject<FloatComparingBiomeCondition> TEMPERATURE = ApoliRegisters.BIOME_CONDITIONS.register("temperature", () -> new FloatComparingBiomeCondition(x -> Float.valueOf(x.m_203633_() ? ((Biome)x.m_203334_()).m_47554_() : 0.2f)));

    private static <U extends BiomeCondition<?>> RegistryObject<U> of(String name) {
        return RegistryObject.create((ResourceLocation)Apoli.identifier(name), (ResourceLocation)ApoliRegistries.BIOME_CONDITION_KEY.m_135782_(), (String)"apoli");
    }

    public static ConfiguredBiomeCondition<?, ?> constant(boolean value) {
        return (ConfiguredBiomeCondition)((DelegatedBiomeCondition)CONSTANT.get()).configure(new ConstantConfiguration(value));
    }

    @SafeVarargs
    public static ConfiguredBiomeCondition<?, ?> and(HolderSet<ConfiguredBiomeCondition<?, ?>> ... conditions) {
        return (ConfiguredBiomeCondition)((DelegatedBiomeCondition)AND.get()).configure(ConditionStreamConfiguration.and(Arrays.asList(conditions), PREDICATE));
    }

    @SafeVarargs
    public static ConfiguredBiomeCondition<?, ?> or(HolderSet<ConfiguredBiomeCondition<?, ?>> ... conditions) {
        return (ConfiguredBiomeCondition)((DelegatedBiomeCondition)OR.get()).configure(ConditionStreamConfiguration.or(Arrays.asList(conditions), PREDICATE));
    }

    public static void bootstrap() {
        MetaFactories.defineMetaConditions(ApoliRegisters.BIOME_CONDITIONS, DelegatedBiomeCondition::new, ConfiguredBiomeCondition.CODEC_SET, PREDICATE);
    }
}

