/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power.configuration;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemCondition;
import io.github.edwinmindcraft.apoli.api.registry.ApoliBuiltinRegistries;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record RestrictArmorConfiguration(Map<EquipmentSlot, Holder<ConfiguredItemCondition<?, ?>>> conditions, int tickRate) implements IDynamicFeatureConfiguration
{
    private static final MapCodec<Map<EquipmentSlot, Holder<ConfiguredItemCondition<?, ?>>>> EQUIPMENT_MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ConfiguredItemCondition.optional("head").forGetter(x -> Optional.ofNullable((Holder)x.get(EquipmentSlot.HEAD)).orElseGet(RestrictArmorConfiguration::itemDefault)), (App)ConfiguredItemCondition.optional("chest").forGetter(x -> Optional.ofNullable((Holder)x.get(EquipmentSlot.CHEST)).orElseGet(RestrictArmorConfiguration::itemDefault)), (App)ConfiguredItemCondition.optional("legs").forGetter(x -> Optional.ofNullable((Holder)x.get(EquipmentSlot.LEGS)).orElseGet(RestrictArmorConfiguration::itemDefault)), (App)ConfiguredItemCondition.optional("feet").forGetter(x -> Optional.ofNullable((Holder)x.get(EquipmentSlot.FEET)).orElseGet(RestrictArmorConfiguration::itemDefault))).apply((Applicative)instance, (head, chest, legs, feet) -> {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)EquipmentSlot.HEAD, head);
        builder.put((Object)EquipmentSlot.CHEST, chest);
        builder.put((Object)EquipmentSlot.LEGS, legs);
        builder.put((Object)EquipmentSlot.FEET, feet);
        return builder.build();
    }));
    public static final Codec<RestrictArmorConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EQUIPMENT_MAP_CODEC.forGetter(RestrictArmorConfiguration::conditions), (App)CalioCodecHelper.optionalField(CalioCodecHelper.INT, "tick_rate", 80).forGetter(RestrictArmorConfiguration::tickRate)).apply((Applicative)instance, RestrictArmorConfiguration::new));

    private static Holder<ConfiguredItemCondition<?, ?>> itemDefault() {
        return (Holder)ApoliBuiltinRegistries.CONFIGURED_ITEM_CONDITIONS.get().getHolder(ApoliDynamicRegistries.DENY).orElseThrow();
    }

    public boolean check(EquipmentSlot slot, Level level, ItemStack stack) {
        return this.conditions.get(slot) != null && ConfiguredItemCondition.check(this.conditions.get(slot), level, stack);
    }

    public void dropIllegalItems(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        this.conditions().forEach((slot, predicate) -> {
            ItemStack equippedItem = living.m_6844_(slot);
            if (!equippedItem.m_41619_() && ConfiguredItemCondition.check(predicate, living.f_19853_, equippedItem)) {
                if (entity instanceof Player) {
                    Player ple = (Player)entity;
                    if (!ple.m_150109_().m_36054_(equippedItem)) {
                        ple.m_36176_(equippedItem, true);
                    }
                } else {
                    entity.m_19983_(equippedItem);
                }
                entity.m_8061_(slot, ItemStack.f_41583_);
            }
        });
    }
}

