/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityCondition;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.NonNullSupplier;

public record PhasingConfiguration(Holder<ConfiguredBlockCondition<?, ?>> phaseCondition, boolean blacklist, RenderType renderType, float viewDistance, Holder<ConfiguredEntityCondition<?, ?>> phaseDownCondition) implements IDynamicFeatureConfiguration
{
    public static final Codec<PhasingConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfiguredBlockCondition.optional("block_condition").forGetter(PhasingConfiguration::phaseCondition), (App)CalioCodecHelper.optionalField(CalioCodecHelper.BOOL, "blacklist", false).forGetter(PhasingConfiguration::blacklist), (App)SerializableDataType.enumValue(RenderType.class).optionalFieldOf("render_type", (Object)RenderType.BLINDNESS).forGetter(PhasingConfiguration::renderType), (App)CalioCodecHelper.optionalField(CalioCodecHelper.FLOAT, "view_distance", Float.valueOf(10.0f)).forGetter(PhasingConfiguration::viewDistance), (App)ConfiguredEntityCondition.optional("phase_down_condition").forGetter(PhasingConfiguration::phaseDownCondition)).apply((Applicative)instance, PhasingConfiguration::new));

    public boolean canPhaseDown(Entity entity) {
        return !this.phaseDownCondition().m_203633_() ? entity.m_6047_() : ((ConfiguredEntityCondition)this.phaseDownCondition().m_203334_()).check(entity);
    }

    public boolean canPhaseThrough(LevelReader reader, BlockPos pos, NonNullSupplier<BlockState> stateGetter) {
        return this.blacklist() != ConfiguredBlockCondition.check(this.phaseCondition(), reader, pos, stateGetter);
    }

    public static enum RenderType {
        BLINDNESS,
        REMOVE_BLOCKS,
        NONE;

    }
}

