/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.FeatureAccess;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public record ModifyPlayerSpawnConfiguration(ResourceKey<Level> dimension, float distanceMultiplier, @Nullable ResourceKey<Biome> biome, String strategy, @Nullable ResourceKey<ConfiguredStructureFeature<?, ?>> structure, @Nullable SoundEvent sound) implements IDynamicFeatureConfiguration
{
    public static final Codec<ModifyPlayerSpawnConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializableDataTypes.DIMENSION.fieldOf("dimension").forGetter(ModifyPlayerSpawnConfiguration::dimension), (App)CalioCodecHelper.optionalField(CalioCodecHelper.FLOAT, "dimension_distance_multiplier", Float.valueOf(0.0f)).forGetter(ModifyPlayerSpawnConfiguration::distanceMultiplier), (App)CalioCodecHelper.resourceKey(Registry.f_122885_).optionalFieldOf("biome").forGetter(x -> Optional.ofNullable(x.biome())), (App)CalioCodecHelper.optionalField(Codec.STRING, "spawn_strategy", "default").forGetter(ModifyPlayerSpawnConfiguration::strategy), (App)CalioCodecHelper.optionalField(SerializableDataType.registryKey(Registry.f_122882_), "structure").forGetter(x -> Optional.ofNullable(x.structure())), (App)CalioCodecHelper.optionalField(SerializableDataTypes.SOUND_EVENT, "respawn_sound").forGetter(x -> Optional.ofNullable(x.sound()))).apply((Applicative)instance, (t1, t2, t3, t4, t5, t6) -> new ModifyPlayerSpawnConfiguration((ResourceKey<Level>)t1, t2.floatValue(), (ResourceKey<Biome>)((ResourceKey)t3.orElse(null)), (String)t4, t5.orElse(null), t6.orElse(null))));

    @Nullable
    private static Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> getStructureLocation(Level world, @Nullable ResourceKey<ConfiguredStructureFeature<?, ?>> structure, @Nullable TagKey<ConfiguredStructureFeature<?, ?>> structureTag, ResourceKey<Level> dimension) {
        Registry registry = world.m_5962_().m_175515_(Registry.f_122882_);
        HolderSet entryList = null;
        Object structureOrTagName = "";
        if (structure != null) {
            Optional entry = registry.m_203636_(structure);
            if (entry.isPresent()) {
                entryList = HolderSet.m_205809_((Holder[])new Holder[]{(Holder)entry.get()});
            }
            structureOrTagName = structure.m_135782_().toString();
        }
        if (entryList == null && structureTag != null) {
            Optional optionalList = registry.m_203431_(structureTag);
            if (optionalList.isPresent()) {
                entryList = (HolderSet)optionalList.get();
            }
            structureOrTagName = "#" + structureTag.f_203868_();
        }
        if (entryList == null) {
            Apoli.LOGGER.warn("Could not find feature: \"{}\" in registries.", structure);
            return null;
        }
        BlockPos blockPos = new BlockPos(0, 70, 0);
        ServerLevel serverWorld = ServerLifecycleHooks.getCurrentServer().m_129880_(dimension);
        if (serverWorld == null) {
            Apoli.LOGGER.warn("No such dimension: {}", (Object)dimension.m_135782_());
            return null;
        }
        Pair result = serverWorld.m_7726_().m_8481_().m_207970_(serverWorld, entryList, blockPos, 100, false);
        if (result == null) {
            Apoli.LOGGER.warn("Could not find structure \"{}\" in dimension: {}", structureOrTagName, (Object)dimension.m_135782_());
            return null;
        }
        return new Pair((Object)((BlockPos)result.getFirst()), (Object)((Holder)result.getSecond()));
    }

    @Nullable
    private static Vec3 getValidSpawn(BlockPos startPos, int range, ServerLevel world) {
        world.m_6522_(startPos.m_123341_() >> 4, startPos.m_123343_() >> 4, ChunkStatus.f_62326_, true);
        int dx = 1;
        int dz = 0;
        int segmentLength = 1;
        BlockPos.MutableBlockPos mutable = startPos.m_122032_();
        int center = startPos.m_123342_();
        int x = startPos.m_123341_();
        int z = startPos.m_123343_();
        int segmentPassed = 0;
        int i = 0;
        for (int d = 0; i < world.m_143344_() || d > 0; ++i, --d) {
            for (int coordinateCount = 0; coordinateCount < range; ++coordinateCount) {
                ++segmentPassed;
                mutable.m_142451_(x += dx);
                mutable.m_142443_(z += dz);
                mutable.m_142448_(center + i);
                Vec3 tpPos = DismountHelper.m_38441_((EntityType)EntityType.f_20532_, (CollisionGetter)world, (BlockPos)mutable, (boolean)true);
                if (tpPos != null) {
                    return tpPos;
                }
                mutable.m_142448_(center + d);
                tpPos = DismountHelper.m_38441_((EntityType)EntityType.f_20532_, (CollisionGetter)world, (BlockPos)mutable, (boolean)true);
                if (tpPos != null) {
                    return tpPos;
                }
                if (segmentPassed != segmentLength) continue;
                segmentPassed = 0;
                int buffer = dx;
                dx = -dz;
                dz = buffer;
                if (dz != 0) continue;
                ++segmentLength;
            }
        }
        return null;
    }

    @Nullable
    public Tuple<ServerLevel, BlockPos> getSpawn(Entity entity, boolean isSpawnObstructed) {
        if (entity instanceof ServerPlayer) {
            Vec3 tpPos;
            ServerLevel world = ServerLifecycleHooks.getCurrentServer().m_129880_(this.dimension);
            BlockPos regularSpawn = Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_)).m_8900_();
            if (world == null) {
                Apoli.LOGGER.warn("Could not find dimension \"{}\".", (Object)this.dimension.toString());
                return null;
            }
            int center = world.m_143344_() / 2;
            int range = 64;
            BlockPos spawnToDimPos = switch (this.strategy()) {
                case "center" -> new BlockPos(0, center, 0);
                case "default" -> {
                    if (this.distanceMultiplier() != 0.0f) {
                        yield new BlockPos((double)((float)regularSpawn.m_123341_() * this.distanceMultiplier()), (double)regularSpawn.m_123342_(), (double)((float)regularSpawn.m_123343_() * this.distanceMultiplier()));
                    }
                    yield new BlockPos(regularSpawn.m_123341_(), regularSpawn.m_123342_(), regularSpawn.m_123343_());
                }
                default -> {
                    Apoli.LOGGER.warn("This case does nothing. The game crashes if there is no spawn strategy set");
                    yield this.distanceMultiplier() != 0.0f ? new BlockPos((double)((float)regularSpawn.m_123341_() * this.distanceMultiplier()), (double)regularSpawn.m_123342_(), (double)((float)regularSpawn.m_123343_() * this.distanceMultiplier())) : new BlockPos(regularSpawn.m_123341_(), regularSpawn.m_123342_(), regularSpawn.m_123343_());
                }
            };
            if (this.biome() != null) {
                Pair biomePos = world.m_207571_(x -> x.m_203565_(this.biome()), spawnToDimPos, 6400, 8);
                if (biomePos != null) {
                    spawnToDimPos = (BlockPos)biomePos.getFirst();
                } else {
                    Apoli.LOGGER.warn("Could not find biome \"{}\" in dimension \"{}\".", this.biome(), (Object)this.dimension.toString());
                }
            }
            if (this.structure == null) {
                tpPos = ModifyPlayerSpawnConfiguration.getValidSpawn(spawnToDimPos, range, world);
            } else {
                Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> structure = ModifyPlayerSpawnConfiguration.getStructureLocation((Level)world, this.structure, null, this.dimension);
                if (structure == null) {
                    return null;
                }
                BlockPos structurePos = (BlockPos)structure.getFirst();
                ChunkPos structureChunkPos = new ChunkPos(structurePos.m_123341_() >> 4, structurePos.m_123343_() >> 4);
                StructureStart structureStart = world.m_8595_().m_207802_(SectionPos.m_123196_((ChunkPos)structureChunkPos, (int)0), (ConfiguredStructureFeature)((Holder)structure.getSecond()).m_203334_(), (FeatureAccess)world.m_46865_(structurePos));
                if (structureStart != null) {
                    BlockPos structureCenter = new BlockPos((Vec3i)structureStart.m_73601_().m_162394_());
                    tpPos = ModifyPlayerSpawnConfiguration.getValidSpawn(structureCenter, range, world);
                } else {
                    tpPos = null;
                }
            }
            if (tpPos != null) {
                BlockPos.MutableBlockPos mutable;
                BlockPos.MutableBlockPos spawnLocation = mutable = new BlockPos(tpPos.f_82479_, tpPos.f_82480_, tpPos.f_82481_).m_122032_();
                world.m_7726_().m_8387_(TicketType.f_9442_, new ChunkPos((BlockPos)spawnLocation), 11, (Object)Unit.INSTANCE);
                return new Tuple((Object)world, (Object)spawnLocation);
            }
            return null;
        }
        return null;
    }
}

