/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemCondition;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import io.github.edwinmindcraft.calio.api.network.OptionalFuncs;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public record ModifyCraftingConfiguration(@Nullable ResourceLocation recipeIdentifier, Holder<ConfiguredItemCondition<?, ?>> itemCondition, @Nullable ItemStack newStack, Holder<ConfiguredItemAction<?, ?>> itemAction, Holder<ConfiguredEntityAction<?, ?>> entityAction, Holder<ConfiguredBlockAction<?, ?>> blockAction) implements IDynamicFeatureConfiguration
{
    public static final Codec<ModifyCraftingConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CalioCodecHelper.optionalField(SerializableDataTypes.IDENTIFIER, "recipe").forGetter(OptionalFuncs.opt(ModifyCraftingConfiguration::recipeIdentifier)), (App)ConfiguredItemCondition.optional("item_condition").forGetter(ModifyCraftingConfiguration::itemCondition), (App)CalioCodecHelper.optionalField(SerializableDataTypes.ITEM_STACK, "result").forGetter(OptionalFuncs.opt(ModifyCraftingConfiguration::newStack)), (App)ConfiguredItemAction.optional("item_action").forGetter(ModifyCraftingConfiguration::itemAction), (App)ConfiguredEntityAction.optional("entity_action").forGetter(ModifyCraftingConfiguration::entityAction), (App)ConfiguredBlockAction.optional("block_action").forGetter(ModifyCraftingConfiguration::blockAction)).apply((Applicative)instance, (t1, t2, t3, t4, t5, t6) -> new ModifyCraftingConfiguration(t1.orElse(null), (Holder<ConfiguredItemCondition<?, ?>>)t2, t3.orElse(null), (Holder<ConfiguredItemAction<?, ?>>)t4, (Holder<ConfiguredEntityAction<?, ?>>)t5, (Holder<ConfiguredBlockAction<?, ?>>)t6)));

    public boolean doesApply(CraftingContainer container, Recipe<? super CraftingContainer> recipe, Level level) {
        return !(this.recipeIdentifier() != null && !Objects.equals(recipe.m_6423_(), this.recipeIdentifier()) || this.itemCondition().m_203633_() && !ConfiguredItemCondition.check(this.itemCondition(), level, recipe.m_5874_((Container)container)));
    }

    public ItemStack createResult(CraftingContainer container, Recipe<? super CraftingContainer> recipe, Level level) {
        MutableObject stack = new MutableObject();
        if (this.newStack() != null) {
            stack.setValue((Object)this.newStack().m_41777_());
        } else {
            stack.setValue((Object)recipe.m_5874_((Container)container));
        }
        ConfiguredItemAction.execute(this.itemAction(), level, (Mutable<ItemStack>)stack);
        return (ItemStack)stack.getValue();
    }

    public void execute(Entity entity, @Nullable BlockPos pos) {
        if (pos != null && this.blockAction().m_203633_()) {
            ConfiguredBlockAction.execute(this.blockAction(), entity.f_19853_, pos, Direction.UP);
        }
        ConfiguredEntityAction.execute(this.entityAction(), entity);
    }
}

