/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemCondition;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public record ItemOnItemConfiguration(Holder<ConfiguredItemCondition<?, ?>> usingItemCondition, Holder<ConfiguredItemCondition<?, ?>> onItemCondition, int resultFromOnStack, @Nullable ItemStack newStack, Holder<ConfiguredItemAction<?, ?>> usingItemAction, Holder<ConfiguredItemAction<?, ?>> onItemAction, Holder<ConfiguredItemAction<?, ?>> resultItemAction, Holder<ConfiguredEntityAction<?, ?>> entityAction) implements IDynamicFeatureConfiguration
{
    public static final Codec<ItemOnItemConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfiguredItemCondition.optional("using_item_condition").forGetter(ItemOnItemConfiguration::usingItemCondition), (App)ConfiguredItemCondition.optional("on_item_condition").forGetter(ItemOnItemConfiguration::onItemCondition), (App)CalioCodecHelper.optionalField(CalioCodecHelper.INT, "result_from_on_stack", 0).forGetter(ItemOnItemConfiguration::resultFromOnStack), (App)CalioCodecHelper.optionalField(SerializableDataTypes.ITEM_STACK, "result").forGetter(x -> Optional.ofNullable(x.newStack())), (App)ConfiguredItemAction.optional("using_item_action").forGetter(ItemOnItemConfiguration::usingItemAction), (App)ConfiguredItemAction.optional("on_item_action").forGetter(ItemOnItemConfiguration::onItemAction), (App)ConfiguredItemAction.optional("result_item_action").forGetter(ItemOnItemConfiguration::resultItemAction), (App)ConfiguredEntityAction.optional("entity_action").forGetter(ItemOnItemConfiguration::entityAction)).apply((Applicative)instance, (t1, t2, t3, t4, t5, t6, t7, t8) -> new ItemOnItemConfiguration((Holder<ConfiguredItemCondition<?, ?>>)t1, (Holder<ConfiguredItemCondition<?, ?>>)t2, (int)t3, t4.orElse(null), (Holder<ConfiguredItemAction<?, ?>>)t5, (Holder<ConfiguredItemAction<?, ?>>)t6, (Holder<ConfiguredItemAction<?, ?>>)t7, (Holder<ConfiguredEntityAction<?, ?>>)t8)));

    public boolean check(Level level, ItemStack using, ItemStack on) {
        return ConfiguredItemCondition.check(this.usingItemCondition(), level, using) && ConfiguredItemCondition.check(this.onItemCondition(), level, on);
    }

    public void execute(Entity entity, Mutable<ItemStack> using, Mutable<ItemStack> on, Slot slot) {
        MutableObject stack = new MutableObject((Object)ItemStack.f_41583_);
        if (this.newStack() != null) {
            stack.setValue((Object)this.newStack().m_41777_());
        } else if (this.resultFromOnStack() > 0) {
            stack.setValue((Object)((ItemStack)on.getValue()).m_41620_(this.resultFromOnStack()));
        } else {
            stack.setValue((Object)((ItemStack)on.getValue()));
        }
        ConfiguredItemAction.execute(this.resultItemAction(), entity.f_19853_, (Mutable<ItemStack>)stack);
        ConfiguredItemAction.execute(this.usingItemAction(), entity.f_19853_, using);
        ConfiguredItemAction.execute(this.onItemAction(), entity.f_19853_, on);
        if (this.newStack() != null || this.resultItemAction().m_203633_()) {
            if (slot.m_7993_().m_41619_()) {
                slot.m_5852_((ItemStack)stack.getValue());
            } else if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_150109_().m_150079_((ItemStack)stack.getValue());
            }
        }
        ConfiguredEntityAction.execute(this.entityAction(), entity);
    }
}

