/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import io.github.apace100.apoli.integration.PowerLoadEvent;
import io.github.apace100.calio.data.SerializableData;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.configuration.MultipleConfiguration;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class MultiplePower
extends PowerFactory<MultipleConfiguration<ConfiguredPower<?, ?>>> {
    private static final ImmutableSet<String> EXCLUDED = ImmutableSet.of((Object)"type", (Object)"loading_priority", (Object)"name", (Object)"description", (Object)"hidden", (Object)"condition", (Object[])new String[]{"conditions"});
    private static final Predicate<String> ALLOWED = str -> !EXCLUDED.contains(str) && !ApoliAPI.isAdditionalDataField(str);

    public MultiplePower() {
        super(MultipleConfiguration.mapCodec(ConfiguredPower.CODEC, ConfiguredPower.HOLDER, ALLOWED, s -> "_" + s, MultiplePower::reconfigure).codec(), false);
    }

    @Override
    public Map<String, Holder<ConfiguredPower<?, ?>>> getContainedPowers(ConfiguredPower<MultipleConfiguration<ConfiguredPower<?, ?>>, ?> configuration) {
        return configuration.getConfiguration().children();
    }

    private static <C extends IDynamicFeatureConfiguration, F extends PowerFactory<C>> ConfiguredPower<C, ?> reconfigure(String suffix, ConfiguredPower<C, F> source, JsonElement root) {
        MinecraftForge.EVENT_BUS.post((Event)new PowerLoadEvent.Post(new ResourceLocation(SerializableData.CURRENT_NAMESPACE, SerializableData.CURRENT_PATH + suffix), root, source));
        return ((PowerFactory)((Object)source.getFactory())).configure(source.getConfiguration(), source.getData().copyOf().hidden().build());
    }
}

