/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power;

import io.github.apace100.apoli.util.AttributeUtil;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.configuration.ListConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyFoodConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.Mutable;

public class ModifyFoodPower
extends PowerFactory<ModifyFoodConfiguration> {
    public static List<ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower>> getValidPowers(Entity source, ItemStack stack) {
        return ModifyFoodPower.getValidPowers(source, source.f_19853_, stack);
    }

    public static List<ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower>> getValidPowers(Entity source, Level level, ItemStack stack) {
        return IPowerContainer.getPowers(source, (ModifyFoodPower)((Object)ApoliPowers.MODIFY_FOOD.get())).stream().filter(x -> ((ModifyFoodPower)((Object)((Object)x.getFactory()))).check((ConfiguredPower<ModifyFoodConfiguration, ?>)x, level, stack)).collect(Collectors.toList());
    }

    public static boolean isAlwaysEdible(Entity entity, Level level, ItemStack stack) {
        return ModifyFoodPower.getValidPowers(entity, level, stack).stream().anyMatch(x -> ((ModifyFoodConfiguration)x.getConfiguration()).alwaysEdible());
    }

    public static double apply(List<ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower>> source, Level level, ItemStack stack, double baseValue, Function<ModifyFoodConfiguration, ListConfiguration<AttributeModifier>> access) {
        List<AttributeModifier> modifiers = source.stream().filter(x -> ((ModifyFoodPower)((Object)((Object)x.getFactory()))).check((ConfiguredPower<ModifyFoodConfiguration, ?>)x, level, stack)).flatMap(x -> ((ListConfiguration)access.apply((ModifyFoodConfiguration)x.getConfiguration())).getContent().stream()).collect(Collectors.toList());
        return AttributeUtil.applyModifiers(modifiers, baseValue);
    }

    public static void modifyStack(Iterable<ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower>> powers, Level level, Mutable<ItemStack> input) {
        for (ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower> power : powers) {
            if (power.getConfiguration().replaceStack() != null) {
                input.setValue((Object)power.getConfiguration().replaceStack().m_41777_());
            }
            ConfiguredItemAction.execute(power.getConfiguration().itemAction(), level, input);
        }
    }

    public static void execute(List<ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower>> source, Entity entity, Level level, ItemStack stack) {
        source.stream().filter(x -> ((ModifyFoodPower)((Object)((Object)x.getFactory()))).check((ConfiguredPower<ModifyFoodConfiguration, ?>)x, level, stack)).forEach(x -> ((ModifyFoodPower)((Object)((Object)x.getFactory()))).execute((ConfiguredPower<ModifyFoodConfiguration, ?>)x, entity));
    }

    public ModifyFoodPower() {
        super(ModifyFoodConfiguration.CODEC);
    }

    public boolean check(ConfiguredPower<ModifyFoodConfiguration, ?> config, Level level, ItemStack stack) {
        return ConfiguredItemCondition.check(config.getConfiguration().itemCondition(), level, stack);
    }

    public void execute(ConfiguredPower<ModifyFoodConfiguration, ?> config, Entity player) {
        ConfiguredEntityAction.execute(config.getConfiguration().entityAction(), player);
    }
}

