/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power;

import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyFallingConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import java.lang.reflect.Field;
import java.util.OptionalDouble;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.common.ForgeMod;

public class ModifyFallingPower
extends PowerFactory<ModifyFallingConfiguration> {
    private static final UUID SLOW_FALLING_ID;
    private static final AttributeModifier SLOW_FALLING;

    public static void apply(Entity entity, boolean isFalling) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        AttributeInstance attribute = living.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        if (attribute == null) {
            return;
        }
        OptionalDouble max = IPowerContainer.getPowers((Entity)living, (ModifyFallingPower)((Object)ApoliPowers.MODIFY_FALLING.get())).stream().map(ConfiguredPower::getConfiguration).mapToDouble(ModifyFallingConfiguration::velocity).min();
        if (max.isEmpty()) {
            return;
        }
        double modifier = max.getAsDouble() - 0.08;
        AttributeModifier mod = attribute.m_22111_(SLOW_FALLING_ID);
        if (mod == SLOW_FALLING && modifier >= -0.07) {
            return;
        }
        if (isFalling) {
            if (mod != null) {
                if (mod.m_22218_() == modifier) {
                    return;
                }
                attribute.m_22130_(mod);
            }
            attribute.m_22118_(new AttributeModifier(SLOW_FALLING_ID, "Apoli powers", modifier, AttributeModifier.Operation.ADDITION));
        } else {
            attribute.m_22120_(SLOW_FALLING_ID);
        }
    }

    public ModifyFallingPower() {
        super(ModifyFallingConfiguration.CODEC, true);
    }

    private void add(ConfiguredPower<ModifyFallingConfiguration, ?> configuration, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        AttributeInstance attribute = living.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        AttributeModifier modifier = configuration.getConfiguration().modifier(configuration.getRegistryName());
        if (attribute != null && !attribute.m_22109_(modifier)) {
            attribute.m_22118_(modifier);
        }
    }

    private void remove(ConfiguredPower<ModifyFallingConfiguration, ?> configuration, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        AttributeInstance attribute = living.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        AttributeModifier modifier = configuration.getConfiguration().modifier(configuration.getRegistryName());
        if (attribute != null && attribute.m_22109_(modifier)) {
            attribute.m_22130_(modifier);
        }
    }

    static {
        try {
            Field sfi = LivingEntity.class.getDeclaredField("SLOW_FALLING_ID");
            sfi.setAccessible(true);
            SLOW_FALLING_ID = (UUID)sfi.get(null);
            Field sf = LivingEntity.class.getDeclaredField("SLOW_FALLING");
            sf.setAccessible(true);
            SLOW_FALLING = (AttributeModifier)sf.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

