/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power;

import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.power.ActiveCooldownPowerFactory;
import io.github.edwinmindcraft.apoli.common.power.configuration.FireProjectileConfiguration;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class FireProjectilePower
extends ActiveCooldownPowerFactory<FireProjectileConfiguration> {
    public FireProjectilePower() {
        super(FireProjectileConfiguration.CODEC);
        this.ticking();
    }

    protected DataContainer access(ConfiguredPower<FireProjectileConfiguration, ?> configuration, IPowerContainer container) {
        return (DataContainer)configuration.getPowerData(container, DataContainer::new);
    }

    @Override
    protected void execute(ConfiguredPower<FireProjectileConfiguration, ?> configuration, Entity player) {
        DataContainer dataContainer = this.access(configuration, ApoliAPI.getPowerContainer(player));
        dataContainer.isFiringProjectiles = true;
    }

    @Override
    protected long getLastUseTime(ConfiguredPower<FireProjectileConfiguration, ?> configuration, @Nullable IPowerContainer container) {
        if (container != null) {
            return this.access(configuration, (IPowerContainer)container).lastUseTime;
        }
        return Long.MAX_VALUE;
    }

    @Override
    protected void setLastUseTime(ConfiguredPower<FireProjectileConfiguration, ?> configuration, @Nullable IPowerContainer container, long value) {
        if (container != null) {
            this.access(configuration, (IPowerContainer)container).lastUseTime = value;
        }
    }

    @Override
    public void serialize(ConfiguredPower<FireProjectileConfiguration, ?> configuration, IPowerContainer container, CompoundTag tag) {
        this.access(configuration, container).serialize(tag);
    }

    @Override
    public void deserialize(ConfiguredPower<FireProjectileConfiguration, ?> configuration, IPowerContainer container, CompoundTag tag) {
        this.access(configuration, container).deserialize(tag);
    }

    @Override
    public void tick(ConfiguredPower<FireProjectileConfiguration, ?> configuration, Entity entity) {
        DataContainer dataContainer = this.access(configuration, ApoliAPI.getPowerContainer(entity));
        FireProjectileConfiguration config = configuration.getConfiguration();
        if (dataContainer.isFiringProjectiles) {
            long elapsed = this.getElapsedDuration(configuration, entity);
            if (!(dataContainer.finishedStartDelay || config.startDelay() != 0 && elapsed % (long)config.startDelay() != 0L)) {
                dataContainer.finishedStartDelay = true;
            }
            if (!dataContainer.finishedStartDelay) {
                return;
            }
            if (config.interval() == 0) {
                config.playSound(entity);
                if (!entity.f_19853_.m_5776_()) {
                    while (dataContainer.shotProjectiles < config.projectileCount()) {
                        config.fireProjectile(entity);
                        ++dataContainer.shotProjectiles;
                    }
                }
                dataContainer.reset();
            } else if ((entity.m_183503_().m_46467_() - this.getLastUseTime(configuration, entity)) % (long)config.interval() == 0L) {
                ++dataContainer.shotProjectiles;
                if (dataContainer.shotProjectiles <= config.projectileCount()) {
                    config.playSound(entity);
                    if (!entity.f_19853_.m_5776_()) {
                        config.fireProjectile(entity);
                    }
                } else {
                    dataContainer.reset();
                }
            }
        }
    }

    private static class DataContainer {
        private long lastUseTime = Long.MIN_VALUE;
        private int shotProjectiles;
        private boolean finishedStartDelay;
        private boolean isFiringProjectiles;

        private DataContainer() {
        }

        public void serialize(CompoundTag tag) {
            tag.m_128356_("LastUseTime", this.lastUseTime);
            tag.m_128405_("ShotProjectiles", this.shotProjectiles);
            tag.m_128379_("FinishedStartDelay", this.finishedStartDelay);
            tag.m_128379_("IsFiringProjectiles", this.isFiringProjectiles);
        }

        public void reset() {
            this.shotProjectiles = 0;
            this.finishedStartDelay = false;
            this.isFiringProjectiles = false;
        }

        public void deserialize(CompoundTag tag) {
            this.lastUseTime = tag.m_128454_("LastUseTime");
            this.shotProjectiles = tag.m_128451_("ShotProjectiles");
            this.finishedStartDelay = tag.m_128471_("FinishedStartDelay");
            this.isFiringProjectiles = tag.m_128471_("IsFiringProjectiles");
        }
    }
}

