/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.power;

import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.configuration.ColorConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.EntityGlowConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.world.entity.Entity;

public class EntityGlowPower
extends PowerFactory<EntityGlowConfiguration> {
    private final boolean targetSelf;

    private static Stream<ConfiguredPower<EntityGlowConfiguration, EntityGlowPower>> getGlowPowers(Entity actor, Entity target) {
        return Stream.concat(IPowerContainer.getPowers(actor, (EntityGlowPower)((Object)ApoliPowers.ENTITY_GLOW.get())).stream(), IPowerContainer.getPowers(target, (EntityGlowPower)((Object)ApoliPowers.SELF_GLOW.get())).stream());
    }

    public static boolean shouldGlow(Entity actor, Entity target) {
        return EntityGlowPower.getGlowPowers(actor, target).anyMatch(x -> ((EntityGlowPower)((Object)((Object)x.getFactory()))).doesApply((EntityGlowConfiguration)x.getConfiguration(), actor, target));
    }

    public static Optional<ColorConfiguration> getGlowColor(Entity actor, Entity target) {
        return EntityGlowPower.getGlowPowers(actor, target).flatMap(x -> ((EntityGlowPower)((Object)((Object)x.getFactory()))).getColor((EntityGlowConfiguration)x.getConfiguration(), actor, target).stream()).findFirst();
    }

    public EntityGlowPower(boolean targetSelf) {
        super(EntityGlowConfiguration.CODEC);
        this.targetSelf = targetSelf;
    }

    public boolean doesApply(EntityGlowConfiguration configuration, Entity actor, Entity target) {
        return configuration.applyChecks(actor, target, this.targetSelf);
    }

    public Optional<ColorConfiguration> getColor(EntityGlowConfiguration configuration, Entity actor, Entity target) {
        if (this.doesApply(configuration, actor, target) && !configuration.useTeams()) {
            return Optional.of(configuration.color());
        }
        return Optional.empty();
    }
}

