/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.network;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.github.apace100.apoli.Apoli;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.calio.api.CalioAPI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.WritableRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class S2CSynchronizePowerContainer {
    private final int entity;
    private final Multimap<ResourceLocation, ResourceLocation> powerSources;
    private final Map<ResourceLocation, CompoundTag> data;

    @Nullable
    public static S2CSynchronizePowerContainer forEntity(Entity living) {
        return IPowerContainer.get(living).map(container -> {
            HashMultimap powerSources = HashMultimap.create();
            HashMap<ResourceLocation, CompoundTag> data = new HashMap<ResourceLocation, CompoundTag>();
            for (ResourceLocation power : container.getPowerNames()) {
                for (ResourceLocation source : container.getSources(power)) {
                    powerSources.put((Object)power, (Object)source);
                }
                ConfiguredPower configuredPower = container.getPower(power);
                if (configuredPower == null) {
                    Apoli.LOGGER.warn("Invalid power container capability for entity {}", (Object)living.m_6302_());
                    continue;
                }
                CompoundTag tag = configuredPower.serialize((IPowerContainer)container);
                if (tag.m_128456_()) continue;
                data.put(power, tag);
            }
            return new S2CSynchronizePowerContainer(living.m_142049_(), (Multimap<ResourceLocation, ResourceLocation>)powerSources, data);
        }).orElse(null);
    }

    public static S2CSynchronizePowerContainer decode(FriendlyByteBuf buffer) {
        HashMultimap powerSources = HashMultimap.create();
        HashMap<ResourceLocation, CompoundTag> data = new HashMap<ResourceLocation, CompoundTag>();
        int entity = buffer.readInt();
        int powerCount = buffer.m_130242_();
        for (int i = 0; i < powerCount; ++i) {
            ResourceLocation power = buffer.m_130281_();
            int sourceCount = buffer.m_130242_();
            for (int j = 0; j < sourceCount; ++j) {
                ResourceLocation source = buffer.m_130281_();
                powerSources.put((Object)power, (Object)source);
            }
            if (!buffer.readBoolean()) continue;
            data.put(power, buffer.m_130260_());
        }
        return new S2CSynchronizePowerContainer(entity, (Multimap<ResourceLocation, ResourceLocation>)powerSources, data);
    }

    public S2CSynchronizePowerContainer(int entity, Multimap<ResourceLocation, ResourceLocation> powerSources, Map<ResourceLocation, CompoundTag> data) {
        this.entity = entity;
        this.powerSources = powerSources;
        this.data = data;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entity);
        buffer.m_130130_(this.powerSources.keySet().size());
        WritableRegistry<ConfiguredPower<?, ?>> configuredPowers = CalioAPI.getDynamicRegistries().get(ApoliDynamicRegistries.CONFIGURED_POWER_KEY);
        for (Map.Entry powerEntry : this.powerSources.asMap().entrySet()) {
            ResourceLocation power = (ResourceLocation)powerEntry.getKey();
            Collection sources = (Collection)powerEntry.getValue();
            buffer.m_130085_(power);
            buffer.m_130130_(sources.size());
            sources.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130085_(arg_0));
            CompoundTag tag = this.data.get(power);
            if (tag == null || tag.m_128456_()) {
                buffer.writeBoolean(false);
                continue;
            }
            buffer.writeBoolean(true);
            buffer.m_130079_(tag);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleSync() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(this.entity);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            IPowerContainer.get((Entity)living).ifPresent(x -> x.handle(this.powerSources, this.data));
        }
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::handleSync));
        contextSupplier.get().setPacketHandled(true);
    }
}

