/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.network;

import io.github.apace100.apoli.Apoli;
import java.util.OptionalInt;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record S2CSyncAttacker(int self, OptionalInt attacker) {
    public static S2CSyncAttacker decode(FriendlyByteBuf buf) {
        int self = buf.readInt();
        OptionalInt attacker = buf.readBoolean() ? OptionalInt.of(buf.readInt()) : OptionalInt.empty();
        return new S2CSyncAttacker(self, attacker);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.self());
        buf.writeBoolean(this.attacker().isPresent());
        this.attacker().ifPresent(arg_0 -> ((FriendlyByteBuf)buf).writeInt(arg_0));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleSync() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity target = level.m_6815_(this.self());
        if (!(target instanceof LivingEntity)) {
            Apoli.LOGGER.warn("Received unknown target");
            return;
        }
        LivingEntity living = (LivingEntity)target;
        if (this.attacker().isPresent()) {
            Entity attacker = level.m_6815_(this.attacker().getAsInt());
            if (!(attacker instanceof LivingEntity)) {
                Apoli.LOGGER.warn("Received unknown attacker");
                return;
            }
            living.m_6703_((LivingEntity)attacker);
        } else {
            living.m_6703_(null);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::handleSync));
        contextSupplier.get().setPacketHandled(true);
    }
}

