/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.condition.entity;

import io.github.apace100.apoli.Apoli;
import io.github.edwinmindcraft.apoli.api.configuration.FieldConfiguration;
import io.github.edwinmindcraft.apoli.api.power.factory.EntityCondition;
import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AdvancementCondition
extends EntityCondition<FieldConfiguration<ResourceLocation>> {
    public AdvancementCondition() {
        super(FieldConfiguration.codec(ResourceLocation.f_135803_, "advancement"));
    }

    protected boolean testClient(FieldConfiguration<ResourceLocation> configuration, Entity entity) {
        return false;
    }

    @Override
    public boolean check(FieldConfiguration<ResourceLocation> configuration, Entity entity) {
        if (entity instanceof ServerPlayer) {
            Advancement advancement = Objects.requireNonNull(entity.m_20194_()).m_129889_().m_136041_(configuration.value());
            if (advancement == null) {
                Apoli.LOGGER.warn("Advancement \"{}\" did not exist, but was referenced in an \"origins:advancement\" condition.", (Object)configuration.value().toString());
            } else {
                return ((ServerPlayer)entity).m_8960_().m_135996_(advancement).m_8193_();
            }
        }
        return this.testClient(configuration, entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client
    extends AdvancementCondition {
        @Override
        protected boolean testClient(FieldConfiguration<ResourceLocation> configuration, Entity entity) {
            ClientAdvancements advancementManager;
            Advancement advancement;
            if (entity instanceof LocalPlayer && (advancement = (advancementManager = Objects.requireNonNull(Minecraft.m_91087_().m_91403_()).m_105145_()).m_104396_().m_139337_(configuration.value())) != null && advancementManager.f_104390_.containsKey(advancement)) {
                return ((AdvancementProgress)advancementManager.f_104390_.get(advancement)).m_8193_();
            }
            return false;
        }
    }
}

