/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.condition.configuration;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.calio.api.registry.ICalioDynamicRegistryManager;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import org.jetbrains.annotations.NotNull;

public record StatusEffectConfiguration(MobEffect effect, int minAmplifier, int maxAmplifier, int minDuration, int maxDuration) implements IDynamicFeatureConfiguration
{
    public static final Codec<StatusEffectConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializableDataTypes.STATUS_EFFECT.fieldOf("effect").forGetter(StatusEffectConfiguration::effect), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("min_amplifier", (Object)0).forGetter(StatusEffectConfiguration::minAmplifier), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("max_amplifier", (Object)Integer.MAX_VALUE).forGetter(StatusEffectConfiguration::maxAmplifier), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("min_duration", (Object)0).forGetter(StatusEffectConfiguration::minDuration), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("max_duration", (Object)Integer.MAX_VALUE).forGetter(StatusEffectConfiguration::maxDuration)).apply((Applicative)instance, StatusEffectConfiguration::new));

    @Override
    @NotNull
    public List<String> getErrors(@NotNull ICalioDynamicRegistryManager server) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.minAmplifier() <= this.maxAmplifier()) {
            builder.add((Object)"%s/Amplifier range is invalid: [%d,%d]".formatted(this.name(), this.minAmplifier(), this.maxAmplifier()));
        }
        if (this.minDuration() <= this.maxDuration()) {
            builder.add((Object)"%s/Duration range is invalid: [%d,%d]".formatted(this.name(), this.minDuration(), this.maxDuration()));
        }
        return builder.build();
    }

    @Override
    @NotNull
    public List<String> getWarnings(@NotNull ICalioDynamicRegistryManager server) {
        if (this.effect() == null) {
            return ImmutableList.of((Object)(this.name() + "/Missing Effect"));
        }
        return ImmutableList.of();
    }

    @Override
    public boolean isConfigurationValid() {
        return this.effect() != null && this.minAmplifier() <= this.maxAmplifier() && this.minDuration() <= this.maxDuration();
    }
}

