/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.condition.configuration;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.configuration.IntegerComparisonConfiguration;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import io.github.edwinmindcraft.calio.api.registry.ICalioDynamicRegistryManager;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BlockStateConfiguration(String property, @Nullable IntegerComparisonConfiguration comparison, @Nullable Boolean booleanValue, @Nullable String stringValue) implements IDynamicFeatureConfiguration
{
    public static final Codec<BlockStateConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("property").forGetter(BlockStateConfiguration::property), (App)IntegerComparisonConfiguration.OPTIONAL_MAP_CODEC.forGetter(x -> Optional.ofNullable(x.comparison())), (App)CalioCodecHelper.optionalField(CalioCodecHelper.BOOL, "value").forGetter(x -> Optional.ofNullable(x.booleanValue())), (App)CalioCodecHelper.optionalField(Codec.STRING, "enum").forGetter(x -> Optional.ofNullable(x.stringValue()))).apply((Applicative)instance, (t1, t2, t3, t4) -> new BlockStateConfiguration((String)t1, t2.orElse(null), t3.orElse(null), t4.orElse(null))));

    public boolean checkProperty(Object value) {
        boolean flag = false;
        if (this.stringValue() != null) {
            if (value instanceof Enum) {
                Enum enumValue = (Enum)value;
                flag = enumValue.name().equalsIgnoreCase(this.stringValue());
            }
            if (value instanceof StringRepresentable) {
                StringRepresentable stringIdentifiable = (StringRepresentable)value;
                flag |= stringIdentifiable.m_7912_().equalsIgnoreCase(this.stringValue());
            }
        }
        if (this.booleanValue() != null && value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return bool.booleanValue() == this.booleanValue().booleanValue();
        }
        if (this.comparison() != null && value instanceof Integer) {
            Integer intValue = (Integer)value;
            return this.comparison().check(intValue);
        }
        return flag;
    }

    @Override
    @NotNull
    public List<String> getErrors(@NotNull ICalioDynamicRegistryManager server) {
        if (this.booleanValue() == null && this.stringValue() == null && this.comparison() == null) {
            return ImmutableList.of((Object)"BlockState/No check were defined");
        }
        return IDynamicFeatureConfiguration.super.getErrors(server);
    }
}

