/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.action.meta;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.configuration.IStreamConfiguration;
import io.github.edwinmindcraft.apoli.common.action.meta.IDelegatedActionConfiguration;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import io.github.edwinmindcraft.calio.api.network.CodecSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import net.minecraft.core.Holder;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public record IfElseListConfiguration<C, A, V>(List<Pair<Holder<C>, Holder<A>>> entries, BiPredicate<C, V> predicate, BiConsumer<A, V> consumer) implements IDelegatedActionConfiguration<V>,
IStreamConfiguration<Pair<Holder<C>, Holder<A>>>
{
    public static <C, A, V> Codec<IfElseListConfiguration<C, A, V>> codec(CodecSet<C> condition, CodecSet<A> action, BiPredicate<C, V> predicate, BiConsumer<A, V> consumer) {
        Codec pairCodec = RecordCodecBuilder.create(instance -> instance.group((App)condition.holder().fieldOf("condition").forGetter(Pair::getLeft), (App)action.holder().fieldOf("action").forGetter(Pair::getRight)).apply((Applicative)instance, Pair::of));
        return CalioCodecHelper.listOf(pairCodec).fieldOf("actions").xmap(pairs -> new IfElseListConfiguration(pairs, predicate, consumer), IfElseListConfiguration::entries).codec();
    }

    @Override
    @NotNull
    public String name() {
        return "IfElseList";
    }

    @Override
    public List<String> getUnbound() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < this.entries().size(); ++i) {
            Pair<Holder<C>, Holder<A>> pair = this.entries().get(i);
            if (!((Holder)pair.getLeft()).m_203633_()) {
                builder.add((Object)IDynamicFeatureConfiguration.holderAsString("actions[%d]/condition".formatted(i), (Holder)pair.getLeft()));
            }
            if (((Holder)pair.getRight()).m_203633_()) continue;
            builder.add((Object)IDynamicFeatureConfiguration.holderAsString("actions[%d]/action".formatted(i), (Holder)pair.getLeft()));
        }
        return builder.build();
    }

    @Override
    public void execute(V parameters) {
        for (Pair<Holder<C>, Holder<A>> pair : this.entries()) {
            if (!this.predicate().test(((Holder)pair.getKey()).m_203334_(), parameters)) continue;
            this.consumer().accept(((Holder)pair.getValue()).m_203334_(), parameters);
        }
    }
}

