/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.action.entity;

import io.github.edwinmindcraft.apoli.api.configuration.FieldConfiguration;
import io.github.edwinmindcraft.apoli.api.power.factory.EntityAction;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.function.BiConsumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class IntegerEntityAction
extends EntityAction<FieldConfiguration<Integer>> {
    private final BiConsumer<Entity, Integer> action;

    public static IntegerEntityAction ofLiving(BiConsumer<LivingEntity, Integer> action, String field) {
        return new IntegerEntityAction((e, i) -> {
            if (e instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)e;
                action.accept(le, (Integer)i);
            }
        }, field);
    }

    public static IntegerEntityAction ofPlayer(BiConsumer<Player, Integer> action, String field) {
        return new IntegerEntityAction((e, i) -> {
            if (e instanceof Player) {
                Player le = (Player)e;
                action.accept(le, (Integer)i);
            }
        }, field);
    }

    public IntegerEntityAction(BiConsumer<Entity, Integer> action, String field) {
        super(FieldConfiguration.codec(CalioCodecHelper.INT, field));
        this.action = action;
    }

    @Override
    public void execute(FieldConfiguration<Integer> configuration, Entity entity) {
        this.action.accept(entity, configuration.value());
    }
}

