/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.apoli.common.action.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.apoli.util.ApoliConfigs;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import java.util.OptionalInt;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public record CommandConfiguration(String command) implements IDynamicFeatureConfiguration
{
    public static final MapCodec<CommandConfiguration> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("command").forGetter(CommandConfiguration::command)).apply((Applicative)instance, CommandConfiguration::new));
    public static final Codec<CommandConfiguration> CODEC = MAP_CODEC.codec();

    private static CommandSource getSource(Entity entity) {
        boolean validOutput = !(entity instanceof ServerPlayer) || ((ServerPlayer)entity).f_8906_ != null;
        return (Boolean)ApoliConfigs.SERVER.executeCommand.showOutput.get() != false && validOutput ? entity : CommandSource.f_80164_;
    }

    public static OptionalInt executeAt(Entity entity, Vec3 position, String command) {
        MinecraftServer server = entity.f_19853_.m_142572_();
        if (server != null) {
            ServerLevel sl;
            Level level;
            CommandSourceStack source = new CommandSourceStack(CommandConfiguration.getSource(entity), position, entity.m_20155_(), (level = entity.f_19853_) instanceof ServerLevel ? (sl = (ServerLevel)level) : null, ((Integer)ApoliConfigs.SERVER.executeCommand.permissionLevel.get()).intValue(), entity.m_7755_().getString(), entity.m_5446_(), server, entity);
            return OptionalInt.of(server.m_129892_().m_82117_(source, command));
        }
        return OptionalInt.empty();
    }

    public OptionalInt execute(Entity entity) {
        return CommandConfiguration.executeAt(entity, entity.m_20182_(), this.command());
    }

    public OptionalInt execute(Level world, BlockPos pos) {
        MinecraftServer server = world.m_142572_();
        if (server != null) {
            String blockName = world.m_8055_(pos).m_60734_().m_7705_();
            CommandSourceStack source = new CommandSourceStack((CommandSource)((Boolean)ApoliConfigs.SERVER.executeCommand.showOutput.get() != false ? server : CommandSource.f_80164_), new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), new Vec2(0.0f, 0.0f), (ServerLevel)world, ((Integer)ApoliConfigs.SERVER.executeCommand.permissionLevel.get()).intValue(), blockName, (Component)new TranslatableComponent(blockName), server, null);
            return OptionalInt.of(server.m_129892_().m_82117_(source, this.command()));
        }
        return OptionalInt.empty();
    }
}

